package com.kuaike.common.kafka.msg;

import com.google.common.base.Preconditions;
import com.kuaike.common.enums.SkyCommonMsgType;

import com.kuaike.common.enums.SystemEnum;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

import lombok.*;

/**
 * dev_sk_common_msg / sk_common_msg topic消息体结构
 */
@Builder
@ToString
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
public class SkCommonMessage implements Serializable {

    private static final long serialVersionUID = -1851114292573115329L;
    /**
     * 发送系统
     *
     * 参考{@link SystemEnum}的name
     */
    String subSystem;
    /**
     * 时间
     */
    long timestamp;
    /**
     * 消息类型
     *
     * 参考{@link com.kuaike.common.enums.SkyCommonMsgType}的type
     */
    int msgType;
    /**
     * 标识, 可以用来表示唯一标识如:requestId, id等
     */
    String key;
    /**
     * 消息体,通常为json
     */
    String content;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNotBlank(subSystem)&& SystemEnum.contains(subSystem),"subSystem is null or empty or not valid");
        Preconditions.checkArgument(SkyCommonMsgType.contains(msgType),"msgType is not valid");
        Preconditions.checkArgument(StringUtils.isNotBlank(content),"content is null or empty");
    }
}
