package com.kuaike.common.enums;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @apiNote 商品协议类型枚举类
 * @author sun_wen
 */
@Getter
public enum ProtocolTypeEnum {
    A_PROTOCOL("A","非协议"),
    B_PROTOCOL("B","协议"),
    C_PROTOCOL("C","笔试协议"),
    D_PROTOCOL("D","面试协议"),
    E_PROTOCOL("E","笔面直通协议"),
    F_PROTOCOL("F","双考笔试协议"),
    G_PROTOCOL("G","双考笔面协议"),
    H_PROTOCOL("H","双重保障协议"),
    J_PROTOCOL("J","双重保障协议二"),
    K_PROTOCOL("K","无限学笔试协议"),
    L_PROTOCOL("L","无限学笔试协议二"),
    M_PROTOCOL("M","无限学笔面协议"),
    N_PROTOCOL("N","无限学笔面协议二");

    private static final Map<String, ProtocolTypeEnum> MAP;

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(ProtocolTypeEnum.values())
                .collect(Collectors.toMap(ProtocolTypeEnum::getValue, Function.identity())));
    }

    private final String value;
    private final String desc;

    ProtocolTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static ProtocolTypeEnum get(String value) {
        return MAP.get(value);
    }
}
