package com.kuaike.common.enums.order;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 订单来源
 * @title OrderSource
 * @desc TODO 
 * @author zhangbing
 * @date 2018年7月25日
 * @version 1.0
 */
public enum OrderSource {

    OFFLINE(1, "线下报名", "XC"), AGENT(2, "代理商订单", "DL"), TRANSFER(3, "转班", "ZB"), BM(4, "BM", "BM"), 
    MZ(5, "M站", "MZ"), JS(6, "教师平台", "JS"), XX(7, "学习平台", "XX"), HA(8, "华图app面授", "HA"), WK(9, "卫人机考", "WK"),
    JY(10, "华图教育+app", "JY");
    
    private int type;
    private String label;
    private String prefix;
    
    private OrderSource(int type, String label, String prefix) {
        this.type = type;
        this.label = label;
        this.prefix = prefix;
    }
    
    public static Map<Integer, OrderSource> cache;
    
    static {
        cache = Maps.newHashMap();
        for (OrderSource orderSource : OrderSource.values()) {
            cache.put(orderSource.getType(), orderSource);
        }
    }

    public int getType() {
    
        return type;
    }

    public void setType(int type) {
    
        this.type = type;
    }

    public String getLabel() {
    
        return label;
    }

    public void setLabel(String label) {
    
        this.label = label;
    }
    
    public String getPrefix() {
    
        return prefix;
    }

    public void setPrefix(String prefix) {
    
        this.prefix = prefix;
    }

    public static OrderSource get(int type) {
        return cache.get(type);
    }
}

    