/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;

public class PropertiesReader {
    private static Map<String, Properties> filePropMapping = new WeakHashMap<String, Properties>();

    public static String getValue(String fileName, String key, String defaultValue) {
        String value;
        Properties properties = PropertiesReader.getProperties(fileName);
        if (null != properties && StringUtils.isNotBlank((String)(value = properties.getProperty(key)))) {
            return StringUtils.trim((String)value);
        }
        return defaultValue;
    }

    public static String getValue(String fileName, String key) {
        return PropertiesReader.getValue(fileName, key, null);
    }

    public static Properties fillProperties(String fileName) throws MissingResourceException {
        if (!fileName.endsWith(".properties")) {
            fileName = fileName + ".properties";
        }
        return PropertiesReader.getProperties(fileName);
    }

    public static Properties getProperties(String fileName) {
        return PropertiesReader.getProperties(fileName, PropertiesReader.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String fileName, ClassLoader cl) {
        Properties properties = new Properties();
        if (filePropMapping.containsKey(fileName)) {
            properties = filePropMapping.get(fileName);
        } else {
            InputStream is = cl.getResourceAsStream(fileName);
            try {
                try {
                    properties.load(is);
                }
                catch (IOException e) {
                    throw new RuntimeException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a" + fileName, e);
                }
                filePropMapping.put(fileName, properties);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("\u5173\u95ed\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a" + fileName, e);
                }
            }
        }
        return properties;
    }
}

