/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJsonString(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u5bf9\u8c61json\u5b57\u7b26\u4e32\u5931\u8d25\uff0c\u5bf9\u8c61\uff1a{}", object);
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> toMap(String jsonString) {
        return JsonUtil.fromJson(jsonString, Map.class);
    }

    public static Map<String, Object> toMap(Object object) {
        try {
            return (Map)OBJECT_MAPPER.readValue(JsonUtil.toJsonString(object), (TypeReference)new TypeReference<HashMap>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <E> List<E> toList(String json, Class<E> clazz) {
        ArrayList list;
        try {
            list = (ArrayList)OBJECT_MAPPER.readValue(json, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(ArrayList.class, clazz));
            if (list == null) {
                list = new ArrayList();
            }
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362json\u5b57\u7b26\u4e32\u4e3alist\u96c6\u5408\u5931\u8d25\uff0cjson\u4e3a\uff1a{}\uff0c\u7c7b\u540d\u4e3a\uff1a{}", (Object)json, (Object)clazz.getName());
            throw new RuntimeException(e);
        }
        return list;
    }

    public static <T> T fromJson(String jsonString, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            log.error("\u8f6c\u6362json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5931\u8d25\uff0cjson\u4e3a\uff1a{}\uff0c\u7c7b\u540d\u4e3a\uff1a{}", (Object)jsonString, (Object)clazz.getName());
            throw new RuntimeException(e);
        }
    }

    public static JsonNode toNode(String json) {
        try {
            return (JsonNode)OBJECT_MAPPER.readValue(json, JsonNode.class);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362json\u5b57\u7b26\u4e32\u4e3ajson\u7ed3\u70b9\u5931\u8d25\uff0cjson\u4e3a\uff1a{}", (Object)json);
            throw new RuntimeException(e);
        }
    }

    static {
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

