/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.util;

import com.kuaike.cas.util.PropertiesReader;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvProperties {
    private static final Logger log = LoggerFactory.getLogger(EnvProperties.class);
    private static final Map<String, String> envMap = new ConcurrentHashMap<String, String>();
    private static volatile boolean hasLoad = false;

    public static synchronized void load() {
        if (!hasLoad) {
            Properties baseProperties = PropertiesReader.getProperties("cas-client-base.properties");
            baseProperties.stringPropertyNames().stream().filter(Objects::nonNull).map(Object::toString).forEach(k -> envMap.put((String)k, baseProperties.getProperty((String)k)));
            Properties properties = PropertiesReader.getProperties("cas-client.properties");
            properties.stringPropertyNames().stream().filter(Objects::nonNull).map(Object::toString).forEach(k -> envMap.put((String)k, properties.getProperty((String)k)));
            hasLoad = true;
            log.info("\u52a0\u8f7dcas\u914d\u7f6e\u6587\u4ef6\u5b8c\u6bd5\uff0c\u914d\u7f6e\u4fe1\u606f\u4e3a\uff1a{}", (Object)properties);
        }
    }

    public static String get(String name, String defaultValue) {
        String value = envMap.get(name);
        return StringUtils.isBlank((String)value) ? defaultValue : value;
    }

    public static String get(String name) {
        return EnvProperties.get(name, "");
    }

    public static Map<String, String> getAll() {
        return Collections.unmodifiableMap(envMap);
    }
}

