/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.session;

import com.kuaike.cas.constants.RedisConstants;
import com.kuaike.cas.context.AccessControlContext;
import com.kuaike.cas.core.RedisTemplateLocator;
import com.kuaike.cas.dto.AccountDto;
import com.kuaike.cas.dto.AppDto;
import com.kuaike.cas.service.AppAccessControlService;
import com.kuaike.cas.session.AbstractSessionAttributeHolder;
import com.kuaike.cas.session.SessionAttributeHolder;
import com.kuaike.cas.util.JsonUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sessionAppAccessAttributeHolder")
public class SessionAppAccessAttributeHolder
extends AbstractSessionAttributeHolder<List<AppDto>>
implements SessionAttributeHolder<List<AppDto>> {
    private static final Logger log = LoggerFactory.getLogger(SessionAppAccessAttributeHolder.class);
    private static final String APP_ACCESS_KEY_PREFIX = "SSO-STORE-APP-ACCESS-";
    private static final Long ttl = 300L;
    @Autowired
    private AppAccessControlService appAccessControlService;
    @Autowired
    private RedisTemplateLocator redisTemplateLocator;

    @Override
    public void clear(String sessionCookie) {
        this.redisTemplateLocator.lookup().execute(connection -> {
            connection.del((byte[][])new byte[][]{(APP_ACCESS_KEY_PREFIX + sessionCookie).getBytes()});
            return true;
        });
        log.debug("\u6e05\u9664\u6389sessionCookie[{}]\u5bf9\u5e94\u7684\u8d26\u6237\u4fe1\u606f", (Object)sessionCookie);
    }

    @Override
    public List<AppDto> get(String sessionCookie) {
        List<AppDto> appDtos;
        String appDtosJson = (String)this.redisTemplateLocator.lookup().opsForValue().get((Object)(APP_ACCESS_KEY_PREFIX + sessionCookie));
        if (StringUtils.isNotBlank((String)appDtosJson)) {
            appDtos = JsonUtil.toList(appDtosJson, AppDto.class);
        } else {
            AccountDto accountDto = AccessControlContext.getLoginAccount();
            String accountName = AccessControlContext.getLoginAccountName();
            try {
                appDtos = this.appAccessControlService.getAllowedApps(accountDto.getId());
            }
            catch (Exception e) {
                throw new RuntimeException("\u4ece\u8fdc\u7a0b\u83b7\u53d6\u7528\u6237\u53ef\u8bbf\u95ee\u4e1a\u52a1\u7cfb\u7edf\u5217\u8868\u53d1\u751f\u7f51\u7edc\u6545\u969c\uff0c\u8d26\u6237\u540d\u79f0\uff1a" + accountName, e);
            }
            this.redisTemplateLocator.lookup().opsForValue().set((Object)(APP_ACCESS_KEY_PREFIX + sessionCookie), (Object)JsonUtil.toJsonString(accountDto), ttl.longValue(), RedisConstants.EXPIRATION_TIMEUNIT);
            log.debug("\u7528\u6237\u53ef\u8bbf\u95ee\u7528\u6237\u5217\u8868\u4fe1\u606f\u88ab\u6210\u529f\u653e\u5165redis\u4e2d\uff0csessionCookie\uff1a{}\uff0c\u8d26\u53f7\u540d\uff1a{}", (Object)sessionCookie, (Object)accountName);
        }
        return appDtos;
    }
}

