/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.session;

import com.kuaike.cas.constants.RedisConstants;
import com.kuaike.cas.context.AccessControlContext;
import com.kuaike.cas.core.RedisTemplateLocator;
import com.kuaike.cas.dto.AccountDto;
import com.kuaike.cas.session.AbstractSessionAttributeHolder;
import com.kuaike.cas.session.SessionAttributeHolder;
import com.kuaike.cas.util.JsonUtil;
import com.kuaike.ehr.service.StaffService;
import com.kuaike.ehr.service.dto.req.StaffBasicReqDto;
import com.kuaike.ehr.service.dto.resp.StaffBasicRespDto;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sessionAccountAttributeHolder")
public class SessionAccountAttributeHolder
extends AbstractSessionAttributeHolder<AccountDto>
implements SessionAttributeHolder<AccountDto> {
    private static final Logger log = LoggerFactory.getLogger(SessionAccountAttributeHolder.class);
    private final String ACCOUNT_KEY_PREFIX = "SSO-STORE-ACCOUNT-";
    private final Long ttl = 600L;
    @Autowired
    private RedisTemplateLocator redisTemplateLocator;
    @Autowired
    private StaffService staffService;

    @Override
    public void clear(String sessionCookie) {
        this.redisTemplateLocator.lookup().execute(connection -> {
            connection.del((byte[][])new byte[][]{("SSO-STORE-ACCOUNT-" + sessionCookie).getBytes()});
            return true;
        });
        log.debug("\u6e05\u9664\u6389sessionCookie[{}]\u5bf9\u5e94\u7684\u8d26\u6237\u4fe1\u606f", (Object)sessionCookie);
    }

    @Override
    public AccountDto get(String sessionCookie) {
        if (log.isDebugEnabled()) {
            log.debug("\u901a\u8fc7sessionCookie\u67e5\u627e\u7528\u6237\u4fe1\u606f:{}", (Object)sessionCookie);
        }
        AccountDto accountDto = null;
        String accountJson = (String)this.redisTemplateLocator.lookup().opsForValue().get((Object)("SSO-STORE-ACCOUNT-" + sessionCookie));
        if (StringUtils.isNotBlank((String)accountJson)) {
            accountDto = JsonUtil.fromJson(accountJson, AccountDto.class);
        } else {
            String accountName = AccessControlContext.getLoginAccountName();
            Long accountId = AccessControlContext.getLoginAccountId();
            try {
                StaffBasicRespDto staffBasicRespDto;
                StaffBasicReqDto params = new StaffBasicReqDto();
                if (StringUtils.isNotBlank((String)accountName)) {
                    params.setWorkEmailPrefix(accountName);
                } else {
                    params.setId(accountId);
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u8bf7\u6c42ehr-api\uff0c\u67e5\u8be2\u53c2\u6570\u4e3a\uff1a{}", (Object)params);
                }
                if (null != (staffBasicRespDto = this.staffService.getStaffBasic(params))) {
                    accountDto = AccountDto.from(staffBasicRespDto);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u4ece\u8fdc\u7a0b\u83b7\u53d6\u8d26\u53f7\u4fe1\u606f\u53d1\u751f\u7f51\u7edc\u6545\u969c\uff0c\u8d26\u6237\u540d\u79f0\uff1a" + accountName, e);
            }
            if (accountDto == null) {
                throw new RuntimeException("\u4ece\u8fdc\u7a0b\u83b7\u53d6\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff1a\u6ca1\u6709\u8be5\u8d26\u53f7\uff0c\u8d26\u6237\u540d\u79f0\uff1a" + accountName);
            }
            this.redisTemplateLocator.lookup().opsForValue().set((Object)("SSO-STORE-ACCOUNT-" + sessionCookie), (Object)JsonUtil.toJsonString(accountDto), this.ttl.longValue(), RedisConstants.EXPIRATION_TIMEUNIT);
            log.debug("\u7528\u6237\u4fe1\u606f\u88ab\u6210\u529f\u653e\u5165redis\u4e2d\uff0csessionCookie\uff1a{}\uff0c\u8d26\u53f7\u540d\uff1a{}\uff0c\u7528\u6237ID\uff1a{}", new Object[]{sessionCookie, accountName, accountId});
        }
        return accountDto;
    }
}

