/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.session;

import com.fasterxml.jackson.databind.JsonNode;
import com.kuaike.cas.core.RedisTemplateLocator;
import com.kuaike.cas.session.AuthSessionManager;
import com.kuaike.cas.session.SessionAttributeHolderContainer;
import com.kuaike.cas.util.JsonUtil;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisAuthSessionManager
implements AuthSessionManager {
    private static final Logger log = LoggerFactory.getLogger(RedisAuthSessionManager.class);
    private static final long TTL = 86400L;
    private static final TimeUnit CACHE_TIME_UNIT = TimeUnit.SECONDS;
    private static final String SSO_SESSION_COOKIE_KEY_PREFIX = "SSO-SC-2-ASSERTION-";
    private static final String SSO_SESSION_COOKIE_2_ST_KEY_PREFIX = "SSO-MAPPING-SC-2-ST-";
    private static final String SSO_ST_2_SESSION_COOKIE_KEY_PREFIX = "SSO-MAPPING-ST-2-SC-";
    @Autowired
    private RedisTemplateLocator redisTemplateLocator;
    @Autowired
    private SessionAttributeHolderContainer sessionAttributeHolderContainer;

    private static String getST2SCCacheKey(String ticket) {
        return SSO_ST_2_SESSION_COOKIE_KEY_PREFIX + ticket;
    }

    private static String getSC2STCacheKey(String sessionCookie) {
        return SSO_SESSION_COOKIE_2_ST_KEY_PREFIX + sessionCookie;
    }

    private static String getSC2AssertionCacheKey(String sessionCookie) {
        return SSO_SESSION_COOKIE_KEY_PREFIX + sessionCookie;
    }

    @Override
    public void recordSession(String ticket, String sessionCookie, Assertion assertion) {
        this.getRedisTemplate().opsForValue().set((Object)RedisAuthSessionManager.getST2SCCacheKey(ticket), (Object)sessionCookie, 86400L, CACHE_TIME_UNIT);
        this.getRedisTemplate().opsForValue().set((Object)RedisAuthSessionManager.getSC2STCacheKey(sessionCookie), (Object)ticket, 86400L, CACHE_TIME_UNIT);
        this.getRedisTemplate().opsForValue().set((Object)RedisAuthSessionManager.getSC2AssertionCacheKey(sessionCookie), (Object)JsonUtil.toJsonString(assertion), 86400L, CACHE_TIME_UNIT);
        log.info("\u6dfb\u52a0session\u4fe1\u606f\u5230\u5171\u4eab\u5b58\u50a8\u6210\u529f\uff0csessionCookie[{}]\u3001ticket[{}]", (Object)sessionCookie, (Object)ticket);
    }

    @Override
    public Assertion getAssertionBySessionCookie(String sessionCookie) {
        String assertionStr = (String)this.getRedisTemplate().opsForValue().get((Object)RedisAuthSessionManager.getSC2AssertionCacheKey(sessionCookie));
        if (assertionStr == null) {
            return null;
        }
        this.getRedisTemplate().opsForValue().set((Object)RedisAuthSessionManager.getSC2AssertionCacheKey(sessionCookie), (Object)assertionStr, 86400L, CACHE_TIME_UNIT);
        JsonNode assertionNode = JsonUtil.toNode(assertionStr);
        JsonNode principalNode = assertionNode.get("principal");
        if (principalNode == null) {
            throw new RuntimeException("principal\u4e3a\u7a7a\uff0csessionCookie\u4e3a\uff1a" + sessionCookie);
        }
        Map<String, Object> attributes = JsonUtil.toMap(principalNode.get("attributes").toString());
        AttributePrincipalImpl attributePrincipal = new AttributePrincipalImpl(principalNode.get("name").asText(), attributes);
        JsonNode validFromDateNode = assertionNode.get("validFromDate");
        Date validFromDate = null;
        if (validFromDateNode != null && !validFromDateNode.isNull()) {
            validFromDate = new Date(validFromDateNode.asLong());
        }
        JsonNode validUtilDateNode = assertionNode.get("validUtilDate");
        Date validUtilDate = null;
        if (validUtilDateNode != null && !validUtilDateNode.isNull()) {
            validUtilDate = new Date(validUtilDateNode.asLong());
        }
        JsonNode authenticationDateNode = assertionNode.get("authenticationDate");
        Date authenticationDate = null;
        if (authenticationDateNode != null && !authenticationDateNode.isNull()) {
            authenticationDate = new Date(authenticationDateNode.asLong());
        }
        return new AssertionImpl((AttributePrincipal)attributePrincipal, validFromDate, validUtilDate, authenticationDate, Collections.emptyMap());
    }

    @Override
    public String getTicketBySessionCookie(String sessionCookie) {
        return (String)this.getRedisTemplate().opsForValue().get((Object)RedisAuthSessionManager.getSC2STCacheKey(sessionCookie));
    }

    @Override
    public void destroySessionByTicket(String ticket) {
        String ST2SCCacheKey = RedisAuthSessionManager.getST2SCCacheKey(ticket);
        String sessionCookie = (String)this.getRedisTemplate().opsForValue().get((Object)ST2SCCacheKey);
        this.getRedisTemplate().execute(connection -> {
            connection.del((byte[][])new byte[][]{ST2SCCacheKey.getBytes()});
            return true;
        });
        if (sessionCookie == null) {
            log.info("\u5171\u4eab\u5b58\u50a8\u5df2\u4e0d\u5b58\u5728ticket\u5bf9\u5e94\u7684sessionCookie\uff1a{}", (Object)ticket);
        } else {
            this.destroySessionBySessionCookie(sessionCookie);
            log.info("\u4ece\u5171\u4eab\u5b58\u50a8\u5220\u9664ticket\u5bf9\u5e94\u7684session\u4fe1\u606f\uff1a{}", (Object)ticket);
        }
    }

    @Override
    public void destroySessionBySessionCookie(String sessionCookie) {
        if (StringUtils.isBlank((CharSequence)sessionCookie)) {
            log.info("\u4ece\u5171\u4eab\u5b58\u50a8\u5220\u9664sessionCookie\u5bf9\u5e94\u7684session\u4fe1\u606f\u5931\u8d25\uff0csessionCookie\u4e3a\u7a7a");
        } else {
            String SC2STCacheKey = RedisAuthSessionManager.getSC2STCacheKey(sessionCookie);
            String ticket = (String)this.getRedisTemplate().opsForValue().get((Object)SC2STCacheKey);
            this.getRedisTemplate().execute(connection -> {
                connection.del((byte[][])new byte[][]{SC2STCacheKey.getBytes()});
                connection.del((byte[][])new byte[][]{RedisAuthSessionManager.getST2SCCacheKey(ticket).getBytes()});
                connection.del((byte[][])new byte[][]{RedisAuthSessionManager.getSC2AssertionCacheKey(sessionCookie).getBytes()});
                return true;
            });
            this.sessionAttributeHolderContainer.clear(sessionCookie);
            log.info("\u4ece\u5171\u4eab\u5b58\u50a8\u5220\u9664sessionCookie\u5bf9\u5e94\u7684session\u4fe1\u606f\uff1a{}", (Object)sessionCookie);
        }
    }

    @Override
    public String getSessionCookieByTicket(String ticket) {
        return (String)this.getRedisTemplate().opsForValue().get((Object)RedisAuthSessionManager.getST2SCCacheKey(ticket));
    }

    private RedisTemplate<String, String> getRedisTemplate() {
        return this.redisTemplateLocator.lookup();
    }
}

