/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.session;

import com.kuaike.cas.session.HttpSessionStorage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHttpSessionStorage
implements HttpSessionStorage {
    private static final Logger log = LoggerFactory.getLogger(LocalHttpSessionStorage.class);
    private final Map<String, HttpSession> MANAGED_SESSIONS = new ConcurrentHashMap<String, HttpSession>();
    private final Map<String, String> SESSION_ID_TO_TICKET = new ConcurrentHashMap<String, String>();
    private final Map<String, String> TICKET_TO_SESSION_ID = new ConcurrentHashMap<String, String>();

    @Override
    public void addSessionById(String mappingId, HttpSession session) {
        log.info("\u6dfb\u52a0ticket[{}]\u548cHttpSessionId[{}]\u7684\u5bf9\u5e94\u5173\u7cfb", (Object)mappingId, (Object)session.getId());
        String sessionId = session.getId();
        this.SESSION_ID_TO_TICKET.put(sessionId, mappingId);
        this.TICKET_TO_SESSION_ID.put(mappingId, sessionId);
        this.MANAGED_SESSIONS.put(sessionId, session);
    }

    @Override
    public String removeBySessionId(String sessionId) {
        log.info("\u5f00\u59cb\u9500\u6bc1HttpSession[{}]", (Object)sessionId);
        String ticket = this.SESSION_ID_TO_TICKET.remove(sessionId);
        if (ticket != null) {
            this.TICKET_TO_SESSION_ID.remove(ticket);
            log.info("\u627e\u5230HttpSession[{}]\u4e0eticket[{}]\u7684\u5bf9\u5e94\u5173\u7cfb\uff0c\u5df2\u9500\u6bc1", (Object)sessionId, (Object)ticket);
        } else {
            log.info("\u6ca1\u627e\u5230HttpSession[{}]\u5bf9\u5e94\u7684ticket\uff0c\u5ffd\u7565\u4e4b", (Object)sessionId);
        }
        HttpSession session = this.MANAGED_SESSIONS.remove(sessionId);
        if (session != null) {
            try {
                session.invalidate();
                session.setMaxInactiveInterval(1);
                log.info("\u5220\u9664session\uff1a{}\uff0c\u5269\u4f59\u751f\u547d\u65f6\u95f4\uff1a{}\u79d2", (Object)session.getId(), (Object)session.getMaxInactiveInterval());
            }
            catch (IllegalStateException e) {
                log.info("session\u5df2\u88ab\u9500\u6bc1\uff1a{}", (Object)session.getId());
            }
        }
        return ticket;
    }

    @Override
    public String removeSessionByTicket(String ticket) {
        String sessionId = this.TICKET_TO_SESSION_ID.remove(ticket);
        if (sessionId != null) {
            this.removeBySessionId(sessionId);
        }
        return sessionId;
    }
}

