/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.session;

import com.kuaike.cas.session.CookieStrategy;
import com.kuaike.cas.session.DefaultAuthCookieStrategy;
import com.kuaike.cas.session.SessionCookieManager;
import com.kuaike.cas.session.SessionIdGenerator;
import com.kuaike.cas.session.TimedUUIDSessionIdGenerator;
import com.kuaike.cas.util.EnvProperties;
import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AppAuthSessionCookieManager
implements SessionCookieManager {
    private static final Logger log = LoggerFactory.getLogger(AppAuthSessionCookieManager.class);
    private static final String SESSION_COOKIE_NAME = "_const_kuaike_jsession_id_";
    private final SessionIdGenerator sessionIdGenerator = new TimedUUIDSessionIdGenerator();
    private final CookieStrategy cookieStrategy = new DefaultAuthCookieStrategy();

    private static String getSessionCookieSuffix() {
        String serverName = EnvProperties.get("cas.app.index");
        return "." + serverName.replaceAll("https?://", "");
    }

    private static String getSessionCookieName() {
        return SESSION_COOKIE_NAME;
    }

    @Override
    public String create(HttpServletRequest request, HttpServletResponse response) {
        String cookieValue = this.sessionIdGenerator.generate() + AppAuthSessionCookieManager.getSessionCookieSuffix();
        Cookie cookie = new Cookie(AppAuthSessionCookieManager.getSessionCookieName(), cookieValue);
        cookie.setPath(this.cookieStrategy.getPath());
        cookie.setMaxAge(this.cookieStrategy.getExpirationTime());
        cookie.setHttpOnly(this.cookieStrategy.isHttpOnly());
        response.addCookie(cookie);
        log.info("\u4e3a\u8bf7\u6c42\u6dfb\u52a0sessionCookie\uff1a{}", (Object)cookie);
        return cookieValue;
    }

    @Override
    public String get(HttpServletRequest request) {
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isEmpty((Object[])cookies)) {
            return null;
        }
        return Arrays.stream(cookies).filter(c -> AppAuthSessionCookieManager.getSessionCookieName().equals(c.getName())).map(Cookie::getValue).findFirst().orElse(null);
    }

    @Override
    public void delete(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(AppAuthSessionCookieManager.getSessionCookieName(), "");
        cookie.setPath(this.cookieStrategy.getPath());
        cookie.setMaxAge(0);
        cookie.setSecure(true);
        try {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
                session.setMaxInactiveInterval(1);
            }
        }
        catch (IllegalStateException e) {
            log.info("session\u5df2\u88ab\u9500\u6bc1\uff1a{}", (Object)cookie.getValue());
        }
        response.addCookie(cookie);
    }
}

