/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.listener;

import com.kuaike.cas.filter.logout.SessionInvalidMessageConsumer;
import com.kuaike.cas.session.AuthSessionManager;
import com.kuaike.cas.session.HttpSessionStorage;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.collections4.MapUtils;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@WebListener
public class SingleSignOutHttpSessionListener
implements HttpSessionListener {
    private static final Logger log = LoggerFactory.getLogger(SingleSignOutHttpSessionListener.class);

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        log.info("\u76d1\u542c\u5230session\u9500\u6bc1\u4e8b\u4ef6\uff1a{}", (Object)session.getId());
        ServletContext servletContext = session.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        HttpSessionStorage httpSessionStorage = (HttpSessionStorage)applicationContext.getBean(HttpSessionStorage.class);
        AuthSessionManager authSessionManager = (AuthSessionManager)applicationContext.getBean(AuthSessionManager.class);
        Map sessionInvalidMessageConsumerMap = applicationContext.getBeansOfType(SessionInvalidMessageConsumer.class);
        String ticket = httpSessionStorage.removeBySessionId(session.getId());
        if (ticket != null) {
            String sessionCookie = authSessionManager.getSessionCookieByTicket(ticket);
            log.info("\u4f1a\u8bddcookie\u4e3a\uff1a{}", (Object)sessionCookie);
            Optional.ofNullable(sessionCookie).ifPresent(sc -> {
                Assertion assertion = authSessionManager.getAssertionBySessionCookie(sessionCookie);
                Optional.ofNullable(assertion).ifPresent(a -> {
                    if (MapUtils.isNotEmpty((Map)sessionInvalidMessageConsumerMap)) {
                        log.info("\u5f00\u59cb\u8c03\u7528\u4f1a\u8bdd\u5931\u6548\u76d1\u542c\u56de\u8c03\u903b\u8f91\uff0c\u5458\u5de5\u8d26\u53f7:{}", (Object)assertion.getPrincipal().getName());
                        sessionInvalidMessageConsumerMap.forEach((k, v) -> {
                            try {
                                v.onMessage(assertion.getPrincipal().getName(), sessionCookie);
                            }
                            catch (Exception e) {
                                log.warn("\u8c03\u7528\u4f1a\u8bdd\u5931\u6548\u76d1\u542c" + k + "\u5931\u8d25", (Throwable)e);
                            }
                        });
                    }
                });
            });
            authSessionManager.destroySessionByTicket(ticket);
        }
    }
}

