/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.logout;

import com.kuaike.cas.filter.logout.MessageBroadcastManager;
import com.kuaike.cas.session.AuthSessionManager;
import com.kuaike.cas.session.HttpSessionStorage;
import com.kuaike.cas.util.EnvProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.Inflater;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.DefaultMessage;
import org.springframework.data.redis.connection.Message;
import org.springframework.stereotype.Component;

@Component
class SingleSignOutHandler {
    private static final Logger log = LoggerFactory.getLogger(SingleSignOutHandler.class);
    private static final int DECOMPRESSION_FACTOR = 10;
    @Autowired
    private HttpSessionStorage httpSessionStorage;
    @Autowired
    private AuthSessionManager authSessionManager;
    @Autowired
    private MessageBroadcastManager messageBroadcastManager;
    private String artifactParameterName = Protocol.CAS2.getArtifactParameterName();
    private String logoutParameterName = (String)ConfigurationKeys.LOGOUT_PARAMETER_NAME.getDefaultValue();
    private String relayStateParameterName = (String)ConfigurationKeys.RELAY_STATE_PARAMETER_NAME.getDefaultValue();
    private String casServerUrlPrefix = "";
    private boolean artifactParameterOverPost = false;
    private boolean eagerlyCreateSessions = true;
    private List<String> safeParameters;

    SingleSignOutHandler() {
    }

    void setArtifactParameterOverPost(boolean artifactParameterOverPost) {
        this.artifactParameterOverPost = artifactParameterOverPost;
    }

    void setArtifactParameterName(String name) {
        this.artifactParameterName = name;
    }

    void setLogoutParameterName(String name) {
        this.logoutParameterName = name;
    }

    void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    void setRelayStateParameterName(String name) {
        this.relayStateParameterName = name;
    }

    void setEagerlyCreateSessions(boolean eagerlyCreateSessions) {
        this.eagerlyCreateSessions = eagerlyCreateSessions;
    }

    synchronized void init() {
        if (this.safeParameters == null) {
            CommonUtils.assertNotNull((Object)this.artifactParameterName, (String)"artifactParameterName cannot be null.");
            CommonUtils.assertNotNull((Object)this.logoutParameterName, (String)"logoutParameterName cannot be null.");
            CommonUtils.assertNotNull((Object)this.httpSessionStorage, (String)"httpSessionStorage cannot be null.");
            CommonUtils.assertNotNull((Object)this.relayStateParameterName, (String)"relayStateParameterName cannot be null.");
            CommonUtils.assertNotNull((Object)this.casServerUrlPrefix, (String)"casServerUrlPrefix cannot be null.");
            if (CommonUtils.isBlank((String)this.casServerUrlPrefix)) {
                log.warn("Front Channel single sign out redirects are disabled when the 'casServerUrlPrefix' value is not set.");
            }
            this.safeParameters = this.artifactParameterOverPost ? Arrays.asList(this.logoutParameterName, this.artifactParameterName) : Collections.singletonList(this.logoutParameterName);
        }
    }

    private boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.artifactParameterName, this.safeParameters));
    }

    private boolean isLogoutRequest(HttpServletRequest request) {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            return !this.isMultipartRequest(request) && CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName, this.safeParameters));
        }
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName, this.safeParameters));
        }
        return false;
    }

    boolean process(HttpServletRequest request, HttpServletResponse response) {
        if (this.isLogoutRequest(request)) {
            log.info("\u6536\u5230\u6765\u81eacas\u670d\u52a1\u5668\u63a8\u9001\u7684\u767b\u51fa\u8bf7\u6c42\uff0c\u8bf7\u6c42\u65b9\u6cd5\uff1a{}\uff0c\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)request.getMethod(), (Object)request.getRequestURI());
            this.destroySession(request);
            return false;
        }
        log.trace("Ignoring URI for logout: {}", (Object)request.getRequestURI());
        return true;
    }

    private String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = DatatypeConverter.parseBase64Binary((String)originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result);
            String string = new String(result, 0, resultLength, "UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("Unable to decompress logout message", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }

    private String parseToken(HttpServletRequest request) {
        String logoutMessage = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName, this.safeParameters);
        if (CommonUtils.isBlank((String)logoutMessage)) {
            log.error("Could not locate logout message of the request from {}", (Object)this.logoutParameterName);
            return null;
        }
        if (!logoutMessage.contains("SessionIndex")) {
            logoutMessage = this.uncompressLogoutMessage(logoutMessage);
        }
        log.debug("cas\u670d\u52a1\u5668\u56de\u8c03\u767b\u51fa\u6d88\u606f\u4e3a\uff1a\n{}", (Object)logoutMessage);
        String token = XmlUtils.getTextForElement((String)logoutMessage, (String)"SessionIndex");
        log.info("cas\u670d\u52a1\u5668\u56de\u8c03\u8fd4\u56de\u7684ST\u4e3a\uff1a\n{}", (Object)token);
        return token;
    }

    private void destroySession(HttpServletRequest request) {
        String token = this.parseToken(request);
        if (CommonUtils.isNotBlank((String)token)) {
            this.destroySessionByTicket(token);
            String LOGOUT_MESSAGE_BROADCAST_CHANNEL = "cas.logout.topic";
            String logoutTopic = EnvProperties.get(LOGOUT_MESSAGE_BROADCAST_CHANNEL);
            this.messageBroadcastManager.broadcast((Message)new DefaultMessage(logoutTopic.getBytes(), token.getBytes()));
            log.info("\u5411\u5176\u4ed6\u670d\u52a1\u5668\u5e7f\u64ad\u7528\u6237\u9000\u51fa\u6d88\u606f\uff0ctopic\uff1a{}\uff0cticket\uff1a{}", (Object)logoutTopic, (Object)token);
        }
    }

    private void destroySessionByTicket(String ticket) {
        this.httpSessionStorage.removeSessionByTicket(ticket);
        this.authSessionManager.destroySessionByTicket(ticket);
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart");
    }
}

