/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.logout;

import com.kuaike.cas.filter.logout.SingleSignOutHandler;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.AbstractConfigurationFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SingleSignOutFilter
extends AbstractConfigurationFilter {
    @Autowired
    private SingleSignOutHandler singleSignOutHandler;
    private AtomicBoolean handlerInitialized = new AtomicBoolean(false);

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (!this.isIgnoreInitConfiguration()) {
            this.setArtifactParameterName(this.getString(ConfigurationKeys.ARTIFACT_PARAMETER_NAME));
            this.setLogoutParameterName(this.getString(ConfigurationKeys.LOGOUT_PARAMETER_NAME));
            this.setRelayStateParameterName(this.getString(ConfigurationKeys.RELAY_STATE_PARAMETER_NAME));
            this.setCasServerUrlPrefix(this.getString(ConfigurationKeys.CAS_SERVER_URL_PREFIX));
            this.singleSignOutHandler.setArtifactParameterOverPost(this.getBoolean(ConfigurationKeys.ARTIFACT_PARAMETER_OVER_POST));
            this.singleSignOutHandler.setEagerlyCreateSessions(this.getBoolean(ConfigurationKeys.EAGERLY_CREATE_SESSIONS));
        }
        this.singleSignOutHandler.init();
        this.handlerInitialized.set(true);
    }

    private void setArtifactParameterName(String name) {
        this.singleSignOutHandler.setArtifactParameterName(name);
    }

    private void setLogoutParameterName(String name) {
        this.singleSignOutHandler.setLogoutParameterName(name);
    }

    private void setRelayStateParameterName(String name) {
        this.singleSignOutHandler.setRelayStateParameterName(name);
    }

    private void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.singleSignOutHandler.setCasServerUrlPrefix(casServerUrlPrefix);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.handlerInitialized.getAndSet(true)) {
            this.singleSignOutHandler.init();
        }
        if (this.singleSignOutHandler.process(request, response)) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

