/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.logout;

import com.google.common.collect.ImmutableList;
import com.kuaike.cas.filter.logout.MessageConsumer;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class LogoutMessageListener
implements MessageListener,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(LogoutMessageListener.class);
    private volatile List<MessageConsumer> messageConsumers;
    private volatile ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    private void init() {
        Map consumerMap = this.applicationContext.getBeansOfType(MessageConsumer.class);
        if (MapUtils.isNotEmpty((Map)consumerMap)) {
            this.messageConsumers = ImmutableList.copyOf(consumerMap.values());
            log.info("\u53d1\u73b0\u767b\u51fa\u6d88\u606f\u7684\u6d88\u8d39\u8005\uff1a{}", consumerMap.keySet());
        }
    }

    public void onMessage(Message message, byte[] pattern) {
        if (CollectionUtils.isNotEmpty(this.messageConsumers)) {
            this.messageConsumers.forEach(consumer -> {
                try {
                    consumer.onMessage(message);
                }
                catch (Exception e) {
                    log.error("\u767b\u51fa\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff1a" + new String(message.getBody()), (Throwable)e);
                }
            });
        }
    }
}

