/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.authorize;

import com.kuaike.cas.ac.AppAccessAuthorizationManager;
import com.kuaike.cas.context.AccessControlContext;
import com.kuaike.cas.dto.AccountDto;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppAuthorizationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AppAuthorizationFilter.class);
    private static final String DEFAULT_NO_AUTH = "/noAuth";
    private static final String DEFAULT_LOGOUT = "/logout";
    @Autowired
    private AppAccessAuthorizationManager appAccessAuthorizationManager;
    private volatile String noAuthRedirectPage = "/noAuth";
    private volatile String logOutPage = "/logout";
    private volatile boolean ajaxRequestUnReDirect = true;

    public void init(FilterConfig filterConfig) {
        String ajaxRequestUnReDirectValue;
        String logOutPageValue;
        String noAuthRedirectPageValue = filterConfig.getInitParameter("noAuthRedirectPage");
        if (StringUtils.isNotBlank((String)noAuthRedirectPageValue)) {
            this.noAuthRedirectPage = noAuthRedirectPageValue;
        }
        if (StringUtils.isNotBlank((String)(logOutPageValue = filterConfig.getInitParameter("logOutPage")))) {
            this.logOutPage = logOutPageValue;
        }
        if (StringUtils.isNotBlank((String)(ajaxRequestUnReDirectValue = filterConfig.getInitParameter("ajaxRequestUnReDirect")))) {
            this.ajaxRequestUnReDirect = Boolean.parseBoolean(ajaxRequestUnReDirectValue);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (AccessControlContext.mustRequestBeAuthenticated() && !this.canVisitThisApp() && !this.isNoAuthPage(httpRequest) && !this.isLogoutPage(httpRequest)) {
            AccountDto accountDto = AccessControlContext.getLoginAccount();
            log.info("\u7528\u6237[{}]\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u672c\u7cfb\u7edf", (Object)accountDto.getName());
            if (httpRequest.getMethod().equals("POST") && this.ajaxRequestUnReDirect) {
                this.writeAjaxResponse(httpResponse);
            } else {
                this.redirectOnNoAuth(httpResponse);
            }
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isLogoutPage(HttpServletRequest httpRequest) {
        return this.logOutPage.endsWith(httpRequest.getRequestURI());
    }

    private boolean canVisitThisApp() {
        return true;
    }

    private boolean isNoAuthPage(HttpServletRequest httpRequest) {
        return this.noAuthRedirectPage.endsWith(httpRequest.getRequestURI());
    }

    public void destroy() {
    }

    private void redirectOnNoAuth(HttpServletResponse httpResponse) throws IOException {
        httpResponse.sendRedirect(this.noAuthRedirectPage);
    }

    private void writeAjaxResponse(HttpServletResponse httpResponse) {
        httpResponse.setStatus(403);
    }
}

