/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.authenticate;

import com.kuaike.cas.context.AccessControlContext;
import com.kuaike.cas.exception.AuthenticationFailedException;
import com.kuaike.cas.util.JsonUtil;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.utils.ApiResultUtils;
import com.kuaike.common.utils.WebCommonUtil;
import com.kuaike.common.utils.WebCommonsUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedirectOnErrorFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RedirectOnErrorFilter.class);

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block9: {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            try {
                AccessControlContext.clearAll();
                chain.doFilter(request, response);
            }
            catch (AuthenticationFailedException e) {
                if (WebCommonsUtils.isAjaxRequest((HttpServletRequest)httpServletRequest)) {
                    WebCommonUtil.returnMessage((HttpServletResponse)httpServletResponse, (String)JsonUtil.toJsonString(ApiResultUtils.error((UniverseErrorCode)CommonErrorCode.TOKEN_ERROR, (String)e.getMessage())));
                    break block9;
                }
                throw e;
            }
            catch (Exception exception) {
                log.error("\u767b\u5f55\u6216\u8005\u767b\u5f55\u6001\u6821\u9a8c \u5904\u7406\u53d1\u751f\u9519\u8bef\uff0c\u5f53\u524d\u8bf7\u6c42\u8def\u5f84\uff1a" + httpServletRequest.getRequestURI(), (Throwable)exception);
                if (WebCommonsUtils.isAjaxRequest((HttpServletRequest)httpServletRequest)) {
                    WebCommonUtil.returnMessage((HttpServletResponse)httpServletResponse, (String)JsonUtil.toJsonString(ApiResultUtils.error((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR)));
                    break block9;
                }
                throw exception;
            }
            finally {
                AccessControlContext.clearAll();
            }
        }
    }

    public void destroy() {
    }
}

