/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.authenticate;

import com.kuaike.cas.constants.ClientType;
import com.kuaike.cas.context.AccessControlContext;
import com.kuaike.cas.exception.AuthenticationFailedException;
import com.kuaike.cas.util.EnvProperties;
import com.kuaike.common.utils.ApiResult;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MobileAuthenticationDelegateFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MobileAuthenticationDelegateFilter.class);
    private volatile String ignoredUrl = "";

    public void init(FilterConfig filterConfig) {
        this.ignoredUrl = EnvProperties.get("cas.app.ignoredUrlsRegexPattern");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        if (!this.isRequestUrlExcluded(servletRequest)) {
            String tokenType;
            String token = Optional.ofNullable(request.getParameter("token")).orElse(servletRequest.getHeader("token"));
            ApiResult apiResult = this.validate(token, tokenType = request.getParameter("tokenType"));
            if (0L != apiResult.getCode()) {
                throw new AuthenticationFailedException(apiResult.getMsg());
            }
            Long accountId = (Long)apiResult.getData();
            AccessControlContext.setLoginAccountId(accountId);
            AccessControlContext.setSessionCookie(token);
        }
        chain.doFilter(request, response);
    }

    private boolean isRequestUrlExcluded(HttpServletRequest request) {
        boolean isUrlExcluded;
        String requestUri = request.getRequestURI();
        boolean bl = isUrlExcluded = StringUtils.isNotBlank((CharSequence)this.ignoredUrl) && requestUri.matches(this.ignoredUrl);
        if (isUrlExcluded) {
            AccessControlContext.markUrlFreeOfAuthentication();
            log.info("\u8bf7\u6c42\u4e3a\u767b\u5f55\u767d\u540d\u5355\uff0c\u653e\u884c\uff1a{}", (Object)requestUri);
        }
        return isUrlExcluded;
    }

    private ApiResult validate(String token, String tokenType) {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new AuthenticationFailedException("token\u4e3a\u7a7a");
        }
        token = token.replaceAll(" ", "+");
        ClientType clientType = ClientType.get(tokenType);
        ApiResult apiResult = null;
        switch (clientType) {
            case MOB_OA: {
                break;
            }
            case PC_IM: {
                break;
            }
        }
        if (apiResult == null) {
            throw new RuntimeException("\u8eab\u4efd\u8ba4\u8bc1\u670d\u52a1\u5668\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (log.isDebugEnabled()) {
            log.debug("token\u4e3a\uff1a{}, OA\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a{}", (Object)token, apiResult);
        }
        return apiResult;
    }

    public void destroy() {
    }
}

