/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.authenticate;

import com.kuaike.cas.context.AccessControlContext;
import com.kuaike.cas.session.AuthSessionManager;
import com.kuaike.cas.session.SessionCookieManager;
import com.kuaike.cas.util.JsonUtil;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.utils.ApiResultUtils;
import com.kuaike.common.utils.WebCommonUtil;
import com.kuaike.common.utils.WebCommonsUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.authentication.AuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.ContainsPatternUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.ExactUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.authentication.RegexUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusteredAuthenticationFilter
extends AbstractCasFilter {
    private static final Logger log = LoggerFactory.getLogger(ClusteredAuthenticationFilter.class);
    private static final Map<String, Class<? extends UrlPatternMatcherStrategy>> PATTERN_MATCHER_TYPES = new HashMap<String, Class<? extends UrlPatternMatcherStrategy>>();
    @Autowired
    private AuthSessionManager authSessionManager;
    @Autowired
    private SessionCookieManager sessionCookieManager;
    private String casServerLoginUrl;
    private boolean renew = false;
    private boolean gateway = false;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private AuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
    private UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass = null;

    public ClusteredAuthenticationFilter() {
        this(Protocol.CAS2);
    }

    private ClusteredAuthenticationFilter(Protocol protocol) {
        super(protocol);
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        if (!this.isIgnoreInitConfiguration()) {
            Class authenticationRedirectStrategyClass;
            Class gatewayStorageClass;
            super.initInternal(filterConfig);
            this.setCasServerLoginUrl(this.getString(ConfigurationKeys.CAS_SERVER_LOGIN_URL));
            this.setRenew(this.getBoolean(ConfigurationKeys.RENEW));
            this.setGateway(this.getBoolean(ConfigurationKeys.GATEWAY));
            String ignorePattern = this.getString(ConfigurationKeys.IGNORE_PATTERN);
            String ignoreUrlPatternType = this.getString(ConfigurationKeys.IGNORE_URL_PATTERN_TYPE);
            if (ignorePattern != null) {
                Class<? extends UrlPatternMatcherStrategy> ignoreUrlMatcherClass = PATTERN_MATCHER_TYPES.get(ignoreUrlPatternType);
                if (ignoreUrlMatcherClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance((String)ignoreUrlMatcherClass.getName(), (Object[])new Object[0]);
                } else {
                    try {
                        log.trace("Assuming {} is a qualified class name...", (Object)ignoreUrlPatternType);
                        this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance((String)ignoreUrlPatternType, (Object[])new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Could not instantiate class [{}]", (Object)ignoreUrlPatternType, (Object)e);
                    }
                }
                if (this.ignoreUrlPatternMatcherStrategyClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass.setPattern(ignorePattern);
                }
            }
            if ((gatewayStorageClass = this.getClass(ConfigurationKeys.GATEWAY_STORAGE_CLASS)) != null) {
                this.setGatewayStorage((GatewayResolver)ReflectUtils.newInstance((Class)gatewayStorageClass, (Object[])new Object[0]));
            }
            if ((authenticationRedirectStrategyClass = this.getClass(ConfigurationKeys.AUTHENTICATION_REDIRECT_STRATEGY_CLASS)) != null) {
                this.authenticationRedirectStrategy = (AuthenticationRedirectStrategy)ReflectUtils.newInstance((Class)authenticationRedirectStrategyClass, (Object[])new Object[0]);
            }
        }
    }

    public void init() {
        super.init();
        CommonUtils.assertNotNull((Object)this.casServerLoginUrl, (String)"casServerLoginUrl cannot be null.");
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        AccessControlContext.clearSessionCookie();
        AccessControlContext.clearUrlFreeOfAuthentication();
        AccessControlContext.clearLoginAccountName();
        AccessControlContext.clearST();
        if (this.isRequestUrlExcluded(request) || this.isLogined(request) || this.isInTicketValidation(request, response)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.redirectToLogin(request, response);
    }

    private boolean isRequestUrlExcluded(HttpServletRequest request) {
        if (this.ignoreUrlPatternMatcherStrategyClass == null) {
            return false;
        }
        String requestUri = request.getRequestURI();
        if (requestUri.endsWith(".m")) {
            AccessControlContext.markUrlFreeOfAuthentication();
            log.info("\u79fb\u52a8\u7aef\u8bf7\u6c42\u7ed5\u8fc7: {}", (Object)requestUri);
            return true;
        }
        boolean isUrlExcluded = this.ignoreUrlPatternMatcherStrategyClass.matches(requestUri);
        if (isUrlExcluded) {
            AccessControlContext.markUrlFreeOfAuthentication();
            log.info("\u8bf7\u6c42\u4e3a\u767b\u5f55\u767d\u540d\u5355\uff1a{}", (Object)requestUri);
        }
        return isUrlExcluded;
    }

    private boolean isLogined(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String sessionCookie = this.sessionCookieManager.get(request);
        if (StringUtils.isNotBlank((CharSequence)sessionCookie)) {
            Assertion assertion;
            Assertion assertion2 = assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
            if (assertion != null) {
                log.info("\u4ecesession\u83b7\u53d6Assertion\u6210\u529f\uff0csessionCookie\u4e3a\uff1a{}", (Object)sessionCookie);
            } else {
                log.info("\u4ecesession\u83b7\u53d6Assertion\u5931\u8d25\uff0c\u5c1d\u8bd5\u4ece\u5171\u4eab\u5b58\u50a8\u83b7\u53d6\uff0csessionCookie\u4e3a\uff1a{}", (Object)sessionCookie);
                assertion = this.authSessionManager.getAssertionBySessionCookie(sessionCookie);
                if (assertion != null) {
                    request.setAttribute("_const_cas_assertion_", (Object)assertion);
                    log.info("\u4ece\u5171\u4eab\u5b58\u50a8\u83b7\u53d6Assertion\u6210\u529f\uff0csessionCookie\u4e3a\uff1a{}", (Object)sessionCookie);
                } else {
                    log.info("\u4ece\u5171\u4eab\u5b58\u50a8\u83b7\u53d6Assertion\u5931\u8d25\uff0csessionCookie\u4e3a\uff1a{}", (Object)sessionCookie);
                }
            }
            if (assertion != null) {
                AccessControlContext.setLoginAccountName(assertion.getPrincipal().getName());
                AccessControlContext.setSessionCookie(sessionCookie);
                AccessControlContext.setST(this.authSessionManager.getTicketBySessionCookie(sessionCookie));
                return true;
            }
        }
        return false;
    }

    private boolean isInTicketValidation(HttpServletRequest request, HttpServletResponse response) {
        String ticket = this.retrieveTicketFromRequest(request);
        String serviceUrl = this.constructServiceUrl(request, response);
        boolean wasGatewayed = this.gateway && this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
        return CommonUtils.isNotBlank((String)ticket) || wasGatewayed;
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String modifiedServiceUrl;
        String serviceUrl = this.constructServiceUrl(request, response);
        log.debug("\u8bf7\u6c42\u4e2d\u5e76\u6ca1\u53d1\u73b0Assertion\u548cticket");
        if (this.gateway) {
            log.debug("setting gateway attribute in session");
            modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
        } else {
            modifiedServiceUrl = serviceUrl;
        }
        log.debug("\u5f00\u59cb\u62fc\u63a5cas\u767b\u5f55\u8df3\u8f6c\u5730\u5740: {}", (Object)modifiedServiceUrl);
        if (WebCommonsUtils.isAjaxRequest((HttpServletRequest)request)) {
            String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.getProtocol().getServiceParameterName(), (String)"", (boolean)this.renew, (boolean)this.gateway);
            WebCommonUtil.returnMessage((HttpServletResponse)response, (String)JsonUtil.toJsonString(ApiResultUtils.buildApiResult((UniverseErrorCode)CommonErrorCode.NO_LOGIN, (String)"\u7528\u6237\u672a\u767b\u5f55", Collections.singletonMap("redirectUrl", urlToRedirectTo))));
        } else {
            String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.casServerLoginUrl, (String)this.getProtocol().getServiceParameterName(), (String)modifiedServiceUrl, (boolean)this.renew, (boolean)this.gateway);
            log.debug("\u5f00\u59cb\u8df3\u8f6c\u81f3cas\u767b\u5f55\u5730\u5740 \"{}\"", (Object)urlToRedirectTo);
            this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
        }
    }

    private void setRenew(boolean renew) {
        this.renew = renew;
    }

    private void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    private void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    private void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }

    static {
        PATTERN_MATCHER_TYPES.put("CONTAINS", ContainsPatternUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("REGEX", RegexUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("EXACT", ExactUrlPatternMatcherStrategy.class);
    }
}

