/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.authenticate;

import com.kuaike.cas.session.AuthSessionManager;
import com.kuaike.cas.session.HttpSessionStorage;
import com.kuaike.cas.session.SessionCookieManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Cas30ProxyReceivingTicketValidationFilter
extends org.jasig.cas.client.validation.Cas30ProxyReceivingTicketValidationFilter {
    private static final Logger log = LoggerFactory.getLogger(Cas30ProxyReceivingTicketValidationFilter.class);
    @Autowired
    private AuthSessionManager authSessionManager;
    @Autowired
    private SessionCookieManager sessionCookieManager;
    @Autowired
    private HttpSessionStorage localHttpSessionStorage;

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
        log.info("CAS\u670d\u52a1\u5668\u6821\u9a8cST\u6210\u529f\uff0c\u5f00\u59cb\u6dfb\u52a0\u81ea\u5b9a\u5236Session\u4fe1\u606f");
        this.recordLocalSession(request);
        this.recordRemoteSession(request, response, assertion);
    }

    private void recordLocalSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String ticket = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.getProtocol().getArtifactParameterName());
        try {
            this.localHttpSessionStorage.removeBySessionId(session.getId());
            this.localHttpSessionStorage.addSessionById(ticket, session);
        }
        catch (Exception e) {
            log.warn("\u6dfb\u52a0\u672c\u5730\u4f1a\u8bdd\u65f6\u51fa\u73b0\u5f02\u5e38\uff1aticket" + ticket, (Throwable)e);
        }
    }

    private void recordRemoteSession(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
        String oldSessionCookie = this.sessionCookieManager.get(request);
        if (oldSessionCookie != null) {
            this.authSessionManager.destroySessionBySessionCookie(oldSessionCookie);
        }
        String sessionCookie = this.sessionCookieManager.create(request, response);
        String ticket = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.getProtocol().getArtifactParameterName());
        if (StringUtils.isNotBlank((String)sessionCookie)) {
            this.authSessionManager.recordSession(ticket, sessionCookie, assertion);
        }
    }
}

