/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter.authenticate;

import com.kuaike.cas.context.AccessControlContext;
import com.kuaike.cas.dto.AccountDto;
import com.kuaike.cas.session.SessionAttributeHolder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AccountContextInitFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AccountContextInitFilter.class);
    @Autowired
    @Qualifier(value="sessionAccountAttributeHolder")
    private SessionAttributeHolder<AccountDto> sessionAttributeHolder;

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AccessControlContext.init();
        if (AccessControlContext.mustRequestBeAuthenticated()) {
            AccountDto loginAccount = this.sessionAttributeHolder.get(AccessControlContext.getSessionCookie());
            AccessControlContext.setLoginAccount(loginAccount);
            log.debug("\u6210\u529f\u5c06\u8d26\u53f7\u4fe1\u606f\u653e\u5165\u4e0a\u4e0b\u6587\uff1a{}", (Object)loginAccount);
        }
        chain.doFilter(request, response);
    }
}

