/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.filter;

import com.kuaike.cas.util.EnvProperties;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterConfigWrapper
implements FilterConfig {
    private static final Logger log = LoggerFactory.getLogger(FilterConfigWrapper.class);
    private static final Map<String, String> PROPERTIES_NAME_MAPPING = new HashMap<String, String>(){
        private static final long serialVersionUID = -359793774138124263L;
        {
            this.put("serverName", "cas.app");
            this.put("casServerLoginUrl", "cas.server.login");
            this.put("casServerUrlPrefix", "cas.server.urlPrefix");
            this.put("logOutPage", "cas.app.logout");
            this.put("ajaxRequestUnReDirect", "cas.app.ajaxRequestUnReDirect");
            this.put("ignorePattern", "cas.app.ignoredUrlsRegexPattern");
        }
    };
    private FilterConfig filterConfig;

    FilterConfigWrapper(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public String getFilterName() {
        return this.filterConfig.getFilterName();
    }

    public ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    public String getInitParameter(String name) {
        String propertyName = PROPERTIES_NAME_MAPPING.get(name);
        if (StringUtils.isNotBlank((String)propertyName)) {
            String value = EnvProperties.get(propertyName);
            if (StringUtils.isNotBlank((String)value)) {
                log.info("\u4eceEnvProperties\u52a0\u8f7d\u5b57\u6bb5\u6210\u529f\uff1akey:[{}],value:[{}]", (Object)propertyName, (Object)value);
                return value;
            }
            log.warn("\u4eceEnvProperties\u52a0\u8f7d\u5b57\u6bb5:{} \u5931\u8d25, \u4f7f\u7528FilterConfig \u521d\u59cb\u53c2\u6570\u6765\u52a0\u8f7d", (Object)propertyName);
        }
        return this.filterConfig.getInitParameter(propertyName);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.filterConfig.getInitParameterNames();
    }
}

