/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.dto;

import com.kuaike.cas.dto.Node;
import com.kuaike.cas.dto.UserRoleDto;
import com.kuaike.common.dto.resp.GradeDto;
import com.kuaike.ehr.service.dto.resp.StaffBasicRespDto;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class AccountDto {
    private Long id;
    private String name;
    private String staffNo;
    private String mobile;
    private String avatar;
    private Long positionId;
    private Node nodes;
    private Integer sex;
    private Date entryDate;
    private GradeDto gradeDto;
    private List<UserRoleDto> roles;
    private Integer staffStatus;
    private Long businessUnitId;
    private boolean isSuperAdmin = false;

    public static AccountDto from(StaffBasicRespDto respDto) {
        AccountDto accountDto = new AccountDto();
        accountDto.setId(respDto.getId());
        accountDto.setName(respDto.getChineseName());
        accountDto.setMobile(respDto.getMobile());
        accountDto.setStaffNo(respDto.getStaffNo());
        accountDto.setAvatar(respDto.getAvatar());
        accountDto.setEntryDate(respDto.getEntryDate());
        accountDto.setGradeDto(respDto.getGrade());
        Optional.ofNullable(respDto.getPosition()).ifPresent(p -> accountDto.setPositionId(p.getId()));
        Optional.ofNullable(respDto.getBusinessUnit()).ifPresent(b -> accountDto.setBusinessUnitId(b.getId()));
        Optional.ofNullable(respDto.getStaffStatusEnum()).ifPresent(s -> accountDto.setStaffStatus(s.getId()));
        Optional.ofNullable(respDto.getGenderEnum()).ifPresent(g -> accountDto.setSex(g.getId()));
        Optional.ofNullable(respDto.getNode()).ifPresent(n -> accountDto.setNodes(Node.from(n)));
        return accountDto;
    }

    public void setNode(Node node) {
        this.nodes = node;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getStaffNo() {
        return this.staffNo;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public Long getPositionId() {
        return this.positionId;
    }

    public Node getNodes() {
        return this.nodes;
    }

    public Integer getSex() {
        return this.sex;
    }

    public Date getEntryDate() {
        return this.entryDate;
    }

    public GradeDto getGradeDto() {
        return this.gradeDto;
    }

    public List<UserRoleDto> getRoles() {
        return this.roles;
    }

    public Integer getStaffStatus() {
        return this.staffStatus;
    }

    public Long getBusinessUnitId() {
        return this.businessUnitId;
    }

    public boolean isSuperAdmin() {
        return this.isSuperAdmin;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStaffNo(String staffNo) {
        this.staffNo = staffNo;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public void setNodes(Node nodes) {
        this.nodes = nodes;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    public void setGradeDto(GradeDto gradeDto) {
        this.gradeDto = gradeDto;
    }

    public void setRoles(List<UserRoleDto> roles) {
        this.roles = roles;
    }

    public void setStaffStatus(Integer staffStatus) {
        this.staffStatus = staffStatus;
    }

    public void setBusinessUnitId(Long businessUnitId) {
        this.businessUnitId = businessUnitId;
    }

    public void setSuperAdmin(boolean isSuperAdmin) {
        this.isSuperAdmin = isSuperAdmin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountDto)) {
            return false;
        }
        AccountDto other = (AccountDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$staffNo = this.getStaffNo();
        String other$staffNo = other.getStaffNo();
        if (this$staffNo == null ? other$staffNo != null : !this$staffNo.equals(other$staffNo)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$avatar = this.getAvatar();
        String other$avatar = other.getAvatar();
        if (this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar)) {
            return false;
        }
        Long this$positionId = this.getPositionId();
        Long other$positionId = other.getPositionId();
        if (this$positionId == null ? other$positionId != null : !((Object)this$positionId).equals(other$positionId)) {
            return false;
        }
        Node this$nodes = this.getNodes();
        Node other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        Integer this$sex = this.getSex();
        Integer other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !((Object)this$sex).equals(other$sex)) {
            return false;
        }
        Date this$entryDate = this.getEntryDate();
        Date other$entryDate = other.getEntryDate();
        if (this$entryDate == null ? other$entryDate != null : !((Object)this$entryDate).equals(other$entryDate)) {
            return false;
        }
        GradeDto this$gradeDto = this.getGradeDto();
        GradeDto other$gradeDto = other.getGradeDto();
        if (this$gradeDto == null ? other$gradeDto != null : !this$gradeDto.equals(other$gradeDto)) {
            return false;
        }
        List<UserRoleDto> this$roles = this.getRoles();
        List<UserRoleDto> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Integer this$staffStatus = this.getStaffStatus();
        Integer other$staffStatus = other.getStaffStatus();
        if (this$staffStatus == null ? other$staffStatus != null : !((Object)this$staffStatus).equals(other$staffStatus)) {
            return false;
        }
        Long this$businessUnitId = this.getBusinessUnitId();
        Long other$businessUnitId = other.getBusinessUnitId();
        if (this$businessUnitId == null ? other$businessUnitId != null : !((Object)this$businessUnitId).equals(other$businessUnitId)) {
            return false;
        }
        return this.isSuperAdmin() == other.isSuperAdmin();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $staffNo = this.getStaffNo();
        result = result * 59 + ($staffNo == null ? 43 : $staffNo.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $avatar = this.getAvatar();
        result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
        Long $positionId = this.getPositionId();
        result = result * 59 + ($positionId == null ? 43 : ((Object)$positionId).hashCode());
        Node $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        Integer $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : ((Object)$sex).hashCode());
        Date $entryDate = this.getEntryDate();
        result = result * 59 + ($entryDate == null ? 43 : ((Object)$entryDate).hashCode());
        GradeDto $gradeDto = this.getGradeDto();
        result = result * 59 + ($gradeDto == null ? 43 : $gradeDto.hashCode());
        List<UserRoleDto> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Integer $staffStatus = this.getStaffStatus();
        result = result * 59 + ($staffStatus == null ? 43 : ((Object)$staffStatus).hashCode());
        Long $businessUnitId = this.getBusinessUnitId();
        result = result * 59 + ($businessUnitId == null ? 43 : ((Object)$businessUnitId).hashCode());
        result = result * 59 + (this.isSuperAdmin() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AccountDto(id=" + this.getId() + ", name=" + this.getName() + ", staffNo=" + this.getStaffNo() + ", mobile=" + this.getMobile() + ", avatar=" + this.getAvatar() + ", positionId=" + this.getPositionId() + ", nodes=" + this.getNodes() + ", sex=" + this.getSex() + ", entryDate=" + this.getEntryDate() + ", gradeDto=" + this.getGradeDto() + ", roles=" + this.getRoles() + ", staffStatus=" + this.getStaffStatus() + ", businessUnitId=" + this.getBusinessUnitId() + ", isSuperAdmin=" + this.isSuperAdmin() + ")";
    }
}

