/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.core;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class RedisTemplateLocator
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RedisTemplateLocator.class);
    private volatile ApplicationContext applicationContext;
    @Value(value="${redis.template.beanName}")
    private volatile String redisTemplateBeanName;
    private volatile RedisTemplate<String, String> redisTemplate;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedisTemplate<String, String> lookup() {
        if (null == this.redisTemplate) {
            RedisTemplateLocator redisTemplateLocator = this;
            synchronized (redisTemplateLocator) {
                if (null == this.redisTemplate) {
                    if (StringUtils.isNotEmpty((CharSequence)this.redisTemplateBeanName)) {
                        log.debug("\u901a\u8fc7\u7c7b\u578b\u548c\u540d\u79f0\u67e5\u627eredisTemplace\uff0c\u540d\u79f0\u4e3a\uff1a{}", (Object)this.redisTemplateBeanName);
                        this.redisTemplate = (RedisTemplate)this.applicationContext.getBean(this.redisTemplateBeanName, RedisTemplate.class);
                    } else {
                        log.debug("\u901a\u8fc7\u7c7b\u578b\u67e5\u627eredisTemplace");
                        this.redisTemplate = (RedisTemplate)this.applicationContext.getBean(RedisTemplate.class);
                    }
                    Assert.notNull(this.redisTemplate, (String)("\u627e\u4e0d\u5230RedisTemplace\uff0c\u914d\u7f6e\u7684bean\u540d\u79f0\u4e3a" + this.redisTemplateBeanName));
                }
            }
        }
        return this.redisTemplate;
    }
}

