/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.controller;

import com.kuaike.cas.context.AccessControlContext;
import com.kuaike.cas.dto.QueryAccountReqDto;
import com.kuaike.cas.service.AccountService;
import com.kuaike.cas.session.AuthSessionManager;
import com.kuaike.cas.session.SessionCookieManager;
import com.kuaike.cas.util.EnvProperties;
import com.kuaike.common.utils.ApiResult;
import com.kuaike.common.utils.ApiResultUtils;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ac"})
public class AccountController {
    private static final Logger log = LoggerFactory.getLogger(AccountController.class);
    @Autowired
    private AuthSessionManager authSessionManager;
    @Autowired
    private SessionCookieManager sessionCookieManager;
    @Autowired
    private AccountService accountService;

    @RequestMapping(value={"logout.do"})
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        this.logoutLocal(request, response);
        this.logoutCas(response);
        log.info("\u7528\u6237[{}]\u6210\u529f\u767b\u51fa\u7cfb\u7edf", (Object)AccessControlContext.getLoginAccount().getName());
    }

    @RequestMapping(value={"currentAccount.json", "currentAccount.m"})
    @ResponseBody
    public ApiResult accountDto() {
        return ApiResultUtils.buildApiResult((Object)AccessControlContext.getLoginAccount());
    }

    @RequestMapping(value={"query.json"})
    @ResponseBody
    public ApiResult query(@RequestBody QueryAccountReqDto reqDto) throws Exception {
        return ApiResultUtils.buildApiResult(this.accountService.getByComplexQuery(reqDto));
    }

    private void logoutLocal(HttpServletRequest request, HttpServletResponse response) {
        String sessionCookie = this.sessionCookieManager.get(request);
        this.authSessionManager.destroySessionBySessionCookie(sessionCookie);
        this.sessionCookieManager.delete(request, response);
        log.info("\u7528\u6237\u3010{}\u3011\u5df2\u4ece\u672c\u5730\u767b\u5f55\u6210\u529f\uff0csession\u4fe1\u606f\uff1a{}", (Object)AccessControlContext.getLoginAccountName(), (Object)sessionCookie);
    }

    private void logoutCas(HttpServletResponse response) {
        try {
            response.sendRedirect(this.constructCasLogoutUrl());
            log.info("\u7528\u6237\u3010{}\u3011\u5df2\u4ececas\u767b\u5f55\u6210\u529f", (Object)AccessControlContext.getLoginAccountName());
        }
        catch (IOException e) {
            log.error("\u4ececas\u767b\u9646\u5931\u8d25\uff0c\u7528\u6237\uff1a" + AccessControlContext.getLoginAccountName(), (Throwable)e);
        }
    }

    private String constructCasLogoutUrl() {
        String casServerlogout = EnvProperties.get("cas.server.logout");
        String casAppIndex = EnvProperties.get("cas.app.index");
        if (StringUtils.isNotBlank((String)casAppIndex)) {
            casAppIndex = casAppIndex.contains("?") ? casAppIndex + "&v=" + System.currentTimeMillis() : casAppIndex + "?v=" + System.currentTimeMillis();
            casServerlogout = casServerlogout.contains("?") ? casServerlogout + "&service=" + URLEncoder.encode(casAppIndex) : casServerlogout + "?service=" + URLEncoder.encode(casAppIndex);
        }
        return casServerlogout;
    }
}

