/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.cas.context;

import com.kuaike.cas.dto.AccountDto;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlContext {
    private static final Logger log = LoggerFactory.getLogger(AccessControlContext.class);
    private static final ThreadLocal<HashMap<String, Object>> cache = new ThreadLocal();
    private static final ThreadLocal<String> SESSION_COOKIE_CACHE = new ThreadLocal();
    private static final ThreadLocal<String> ST_CACHE = new ThreadLocal();
    private static final ThreadLocal<Boolean> IS_URL_FREE_OF_AUTHENTICATION = new ThreadLocal();
    private static final ThreadLocal<String> LOGIN_NAME_CACHE = new ThreadLocal();
    private static final ThreadLocal<Long> LOGIN_ACCOUNT_ID_CACHE = new ThreadLocal();

    private AccessControlContext() {
    }

    public static void init() {
        AccessControlContext.clear();
        cache.set(new HashMap());
    }

    public static void clear() {
        cache.remove();
    }

    public static void clearAll() {
        AccessControlContext.clearSessionCookie();
        AccessControlContext.clearUrlFreeOfAuthentication();
        AccessControlContext.clearLoginAccountName();
        AccessControlContext.clearST();
        AccessControlContext.clear();
    }

    public static String getSessionCookie() {
        return SESSION_COOKIE_CACHE.get();
    }

    public static void setSessionCookie(String sessionCookie) {
        SESSION_COOKIE_CACHE.set(sessionCookie);
    }

    public static void clearSessionCookie() {
        SESSION_COOKIE_CACHE.remove();
    }

    public static String getST() {
        return ST_CACHE.get();
    }

    public static void setST(String st) {
        ST_CACHE.set(st);
    }

    public static void clearST() {
        ST_CACHE.remove();
    }

    public static AccountDto getLoginAccount() {
        return (AccountDto)cache.get().get("login_accountDto");
    }

    public static void setLoginAccount(AccountDto account) {
        cache.get().put("login_accountDto", account);
    }

    public static Long getLoginAccountId() {
        AccountDto accountDto = AccessControlContext.getLoginAccount();
        if (accountDto == null) {
            return LOGIN_ACCOUNT_ID_CACHE.get();
        }
        return accountDto.getId();
    }

    public static void setLoginAccountId(Long loginAccountId) {
        LOGIN_ACCOUNT_ID_CACHE.set(loginAccountId);
    }

    public static boolean isLogined() {
        return null != cache.get();
    }

    public static boolean mustRequestBeAuthenticated() {
        return !Boolean.TRUE.equals(IS_URL_FREE_OF_AUTHENTICATION.get());
    }

    public static void markUrlFreeOfAuthentication() {
        IS_URL_FREE_OF_AUTHENTICATION.set(true);
    }

    public static void clearUrlFreeOfAuthentication() {
        IS_URL_FREE_OF_AUTHENTICATION.remove();
    }

    public static String getLoginAccountName() {
        return LOGIN_NAME_CACHE.get();
    }

    public static void setLoginAccountName(String accountName) {
        LOGIN_NAME_CACHE.set(accountName);
    }

    public static void clearLoginAccountName() {
        LOGIN_NAME_CACHE.remove();
    }
}

