/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.validation.support;

import com.iohao.game.common.kit.CollKit;
import com.iohao.game.common.validation.Validator;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;

public class JavaxValidator
implements Validator {
    private final javax.validation.Validator validator;

    public JavaxValidator() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
    }

    @Override
    public String validate(Object data, Class<?> ... groups) {
        Set violationSet = this.validator.validate(data, (Class[])groups);
        if (CollKit.isEmpty((Collection)violationSet)) {
            return null;
        }
        if (!violationSet.isEmpty()) {
            ConstraintViolation violation = (ConstraintViolation)violationSet.iterator().next();
            String propertyName = violation.getPropertyPath().toString();
            return propertyName + " " + violation.getMessage();
        }
        return null;
    }

    @Override
    public boolean isValidator(Class<?> paramClazz) {
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(paramClazz);
        Set descriptorSet = beanDescriptor.getConstrainedProperties();
        return !descriptorSet.isEmpty();
    }
}

