/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.validation.processor;

import autovalue.shaded.com.google.common.auto.service.AutoService;
import com.iohao.game.common.validation.annotation.EnableValidation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.iohao.game.common.validation.annotation.EnableValidation"})
@AutoService(value=Processor.class)
public class ValidationProcessor
extends AbstractProcessor {
    boolean created = false;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!(roundEnv.processingOver() || annotations.isEmpty() || this.created)) {
            this.created = true;
            EnableValidation enableValidation = ValidationProcessor.getEnableValidation(roundEnv);
            if (enableValidation == null) {
                return true;
            }
            String className = enableValidation.value();
            ValidationProcessor.createMetaInf(this.processingEnv, className);
        }
        return true;
    }

    private static EnableValidation getEnableValidation(RoundEnvironment roundEnv) {
        Set<? extends Element> rootElements = roundEnv.getElementsAnnotatedWith(EnableValidation.class);
        if (rootElements != null && !rootElements.isEmpty()) {
            Element element = (Element)rootElements.stream().findFirst().get();
            return element.getAnnotation(EnableValidation.class);
        }
        return null;
    }

    private static void createMetaInf(ProcessingEnvironment processingEnv, String content) {
        try {
            FileObject f = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/ioGame/com.iohao.game.common.validation.Validator", new Element[0]);
            try (Writer w = f.openWriter();){
                PrintWriter pw = new PrintWriter(w);
                pw.println(content);
                pw.flush();
            }
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }
}

