/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.engine.Probe;
import org.beetl.core.engine.ProgramReplaceErrorEvent;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.ProgramMetaData;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.Type;

public class TypeBindingProbe
extends Probe {
    boolean isCompleted = false;
    Type[] types = null;
    ProgramMetaData copyProgramMetaData = null;
    Probe nextFilter = null;
    Map<Integer, String> globalIndex = new HashMap<Integer, String>();

    public TypeBindingProbe(Program p, Probe nextFilter) {
        this.setProgram(p);
        ProgramMetaData metaData = p.metaData;
        this.nextFilter = nextFilter;
        for (Map.Entry<String, Integer> entry : this.program.metaData.globalIndexMap.entrySet()) {
            this.globalIndex.put(entry.getValue(), entry.getKey());
        }
        this.types = new Type[this.program.metaData.varIndexSize];
        if (metaData.allDynamic) {
            for (int i = 0; i < this.types.length; ++i) {
                this.types[i] = Type.ObjectType;
            }
        }
        if (metaData.dynamicObjectSet.size() != 0) {
            for (String string : metaData.dynamicObjectSet) {
                Integer index = metaData.globalIndexMap.get(string);
                if (index == null) continue;
                this.types[index.intValue()] = Type.ObjectType;
            }
        }
        if (metaData.globalType.size() != 0) {
            for (Map.Entry entry : metaData.globalType.entrySet()) {
                String varName = (String)entry.getKey();
                Type type = (Type)entry.getValue();
                Integer index = metaData.globalIndexMap.get(varName);
                if (index == null) continue;
                this.types[index.intValue()] = type;
            }
        }
    }

    public TypeBindingProbe copy() {
        return this;
    }

    public Program getCopyProgram() {
        return this.program;
    }

    @Override
    public void check(Context ctx) {
        if (this.isCompleted) {
            return;
        }
        int y = 0;
        for (int i = 0; i < this.program.metaData.tempVarStartIndex; ++i) {
            if (this.types[i] == null) {
                if (ctx.vars[i] == Context.NOT_EXIST_OBJECT || ctx.vars[i] == null) continue;
                Object o = ctx.vars[i];
                if (this.isDynamicObject(ctx, i)) {
                    this.types[i] = Type.ObjectType;
                    ++y;
                    continue;
                }
                Type c = this.getType(o);
                if (c == null) continue;
                this.types[i] = c;
                ++y;
                continue;
            }
            ++y;
        }
        if (y == this.program.metaData.tempVarStartIndex) {
            try {
                this.infer();
                this.isCompleted = true;
                this.nextFilter.setProgram(this.program);
                this.nextFilter.check(ctx);
            }
            catch (BeetlException bex) {
                ProgramReplaceErrorEvent event = new ProgramReplaceErrorEvent(this.program.res.getId(), bex.getMessage(), bex);
                this.program.gt.fireEvent(event);
                this.isCompleted = true;
            }
        }
    }

    protected void infer() {
        InferContext ctx = new InferContext();
        ctx.types = this.types;
        ctx.gt = this.program.gt;
        for (Statement st : this.program.metaData.statements) {
            st.infer(ctx);
        }
    }

    private boolean isDynamicObject(Context ctx, int index) {
        String varName = this.globalIndex.get(index);
        return ctx.objectKeys != null && ctx.objectKeys.contains(varName);
    }

    private Type getType(Object c) {
        Type type = null;
        if (c instanceof Map) {
            Map map = (Map)c;
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) {
                    return null;
                }
                if (value == null) continue;
                type = new Type(Map.class, key.getClass(), value.getClass());
                return type;
            }
            return null;
        }
        if (c instanceof List) {
            List list = (List)c;
            for (Object o : list) {
                if (o == null) continue;
                type = new Type(List.class, o.getClass());
                return type;
            }
            return null;
        }
        if (c.getClass().isArray()) {
            type = new Type(c.getClass(), c.getClass().getComponentType());
            return type;
        }
        return new Type(c.getClass());
    }
}

