/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.util;

import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);

    public static String getLocalHost() {
        return NetUtils.getHostName();
    }

    public static Integer getPort(String url) {
        Integer port = null;
        try {
            URIBuilder endpointURIBuilder = new URIBuilder(url);
            port = endpointURIBuilder.build().getPort();
        }
        catch (URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return port;
    }

    public static String getHost(String url) {
        String host = null;
        try {
            URIBuilder endpointURIBuilder = new URIBuilder(url);
            host = endpointURIBuilder.build().getHost();
        }
        catch (URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return host;
    }
}

