/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import com.huaweicloud.common.configration.dynamic.MetricsProperties;
import com.huaweicloud.common.context.InvocationFinishEvent;
import com.huaweicloud.common.context.InvocationStage;
import com.huaweicloud.common.event.EventManager;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvocationMetrics.class);
    public static final String TAGS_SEPARATOR = "@";
    public static final String METRICS_PREFIX = "metrics.invocation.";
    public static final String TAG_NAME = "name";
    public static final String TAG_STAGE = "stage";
    public static final String TAG_STATUS = "status";
    public static final String METRICS_CALLS = "metrics.invocation.calls";
    private final MeterRegistry meterRegistry;
    private final MetricsProperties metricsProperties;
    private final Pattern includePattern;
    private final Pattern excludePattern;
    private final ConcurrentMap<String, DistributionSummary> invocationDistribution = new ConcurrentHashMap<String, DistributionSummary>();

    public InvocationMetrics(MeterRegistry meterRegistry, MetricsProperties metricsProperties) {
        this.meterRegistry = meterRegistry;
        this.metricsProperties = metricsProperties;
        this.excludePattern = StringUtils.isNotEmpty((CharSequence)metricsProperties.getExcludePattern()) ? Pattern.compile(metricsProperties.getIncludePattern()) : null;
        this.includePattern = StringUtils.isNotEmpty((CharSequence)metricsProperties.getIncludePattern()) ? Pattern.compile(metricsProperties.getIncludePattern()) : null;
        EventManager.getEventBoundedAsyncEventBus().register((Object)this);
    }

    @Subscribe
    public void onInvocationFinishEvent(InvocationFinishEvent event) {
        InvocationStage stage = event.getInvocationStage();
        this.recordInvocationDistribution(stage.getId(), "all", stage.getStatusCode(), stage.getEndTime() - stage.getBeginTime());
        stage.getStages().forEach((k, v) -> this.recordInvocationDistribution(stage.getId(), (String)k, stage.getStatusCode(), v.getEndTime() - v.getBeginTime()));
    }

    @VisibleForTesting
    void recordInvocationDistribution(String id, String stage, int statusCode, double amount) {
        if (this.byPassMethod(id, stage, statusCode)) {
            return;
        }
        DistributionSummary summary = this.getOrCreateInvocationDistribution(id, stage, statusCode);
        summary.record(amount);
    }

    private boolean byPassMethod(String id, String stage, int statusCode) {
        if (this.excludePattern != null && this.excludePattern.matcher(id).matches()) {
            return true;
        }
        if (this.includePattern != null && !this.includePattern.matcher(id).matches()) {
            return true;
        }
        if (this.invocationDistribution.size() >= this.metricsProperties.getMaxMetricsCount() && !this.invocationDistribution.containsKey(this.buildName(id, stage, statusCode))) {
            LOGGER.warn("metrics count size exceed count {}", (Object)this.metricsProperties.getMaxMetricsCount());
            return true;
        }
        return false;
    }

    private DistributionSummary getOrCreateInvocationDistribution(String id, String stage, int statusCode) {
        return this.invocationDistribution.computeIfAbsent(this.buildName(id, stage, statusCode), key -> DistributionSummary.builder((String)METRICS_CALLS).description("invocation distribution").tag(TAG_NAME, id).tag(TAG_STAGE, stage).tag(TAG_STATUS, Integer.toString(statusCode)).distributionStatisticExpiry(this.metricsProperties.getDistributionStatisticExpiry()).serviceLevelObjectives(this.toDoubleArray(this.metricsProperties.getServiceLevelObjectives())).register(this.meterRegistry));
    }

    private String buildName(String id, String stage, int statusCode) {
        return id + TAGS_SEPARATOR + stage + TAGS_SEPARATOR + statusCode;
    }

    private double[] toDoubleArray(List<Integer> distribution) {
        double[] result = new double[distribution.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Long.valueOf(TimeUnit.MILLISECONDS.toNanos(distribution.get(i).intValue())).doubleValue();
        }
        return result;
    }
}

