/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.webmvc;

import com.huaweicloud.common.adapters.webmvc.DecorateHandlerInterceptor;
import com.huaweicloud.common.adapters.webmvc.InvocationContextFilter;
import com.huaweicloud.common.adapters.webmvc.PostHandlerInterceptor;
import com.huaweicloud.common.adapters.webmvc.PreHandlerInterceptor;
import com.huaweicloud.common.adapters.webmvc.ShutdownHookFilter;
import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.event.ClosedEventListener;
import com.huaweicloud.common.metrics.InvocationMetrics;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.servlet.config.annotation.WebMvcConfigurer"})
public class WebMvcConfiguration {
    @Bean
    public WebMvcConfigurer webMvcConfigurer(@Autowired(required=false) List<PreHandlerInterceptor> preHandlerInterceptors, @Autowired(required=false) List<PostHandlerInterceptor> postHandlerInterceptors, InvocationMetrics invocationMetrics) {
        return new WebMvcConfigurerBean(preHandlerInterceptors, postHandlerInterceptors);
    }

    @Bean
    public FilterRegistrationBean<InvocationContextFilter> invocationContextFilter(ContextProperties contextProperties) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new InvocationContextFilter(contextProperties));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(Integer.MIN_VALUE);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<ShutdownHookFilter> shutdownHookFilter(ContextProperties contextProperties, ClosedEventListener closedEventListener) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new ShutdownHookFilter(contextProperties, closedEventListener));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(-2147483646);
        return registrationBean;
    }

    static class WebMvcConfigurerBean
    implements WebMvcConfigurer {
        private final List<PreHandlerInterceptor> preHandlerInterceptors;
        private final List<PostHandlerInterceptor> postHandlerInterceptors;

        WebMvcConfigurerBean(List<PreHandlerInterceptor> preHandlerInterceptors, List<PostHandlerInterceptor> postHandlerInterceptors) {
            this.preHandlerInterceptors = preHandlerInterceptors;
            this.postHandlerInterceptors = postHandlerInterceptors;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)new DecorateHandlerInterceptor(this.preHandlerInterceptors, this.postHandlerInterceptors)).addPathPatterns(new String[]{"/**"});
        }
    }
}

