/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.webmvc;

import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.event.ClosedEventListener;
import com.huaweicloud.common.event.ClosedEventProcessor;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHookFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHookFilter.class);
    private final ContextProperties contextProperties;
    private volatile boolean isShutDown = false;

    public ShutdownHookFilter(ContextProperties contextProperties, ClosedEventListener closedEventListener) {
        this.contextProperties = contextProperties;
        closedEventListener.addClosedEventProcessor(new ClosedEventProcessor(){

            @Override
            public void process() {
                ShutdownHookFilter.this.close();
            }

            public int getOrder() {
                return 200;
            }
        });
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.isShutDown) {
            LOGGER.warn("application is shutting down, reject request {}", (Object)((HttpServletRequest)request).getRequestURI());
            ((HttpServletResponse)response).sendError(503, "application is shutting down, reject requests");
            return;
        }
        chain.doFilter(request, response);
    }

    private void close() {
        if (this.isShutDown) {
            return;
        }
        LOGGER.warn("application is shutting down, rejecting requests...");
        this.isShutDown = true;
        if (this.contextProperties.getWaitTimeForShutDownInMillis() > 0) {
            try {
                LOGGER.info("wait {}ms for requests done.", (Object)this.contextProperties.getWaitTimeForShutDownInMillis());
                Thread.sleep(this.contextProperties.getWaitTimeForShutDownInMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

