/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.webclient;

import com.huaweicloud.common.adapters.webclient.OrderedExchangeFilterFunction;
import com.huaweicloud.common.adapters.webclient.SerializeContextExchangeFilterFunction;
import com.huaweicloud.common.adapters.webclient.WebClientMetricsExchangeFilterFunction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.reactive.DeferringLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
@ConditionalOnProperty(value={"spring.cloud.servicecomb.webclient.context.enabled"}, havingValue="true", matchIfMissing=true)
public class WebClientConfiguration {
    @Bean
    @Primary
    public WebClient.Builder webClientBuilder(List<ExchangeFilterFunction> exchangeFilterFunctions) {
        ArrayList<ExchangeFilterFunction> resultList = new ArrayList<ExchangeFilterFunction>();
        ExchangeFilterFunction loadBalancerFunction = null;
        for (ExchangeFilterFunction function : exchangeFilterFunctions) {
            if (function instanceof ReactorLoadBalancerExchangeFilterFunction) {
                if (loadBalancerFunction != null) continue;
                loadBalancerFunction = function;
                continue;
            }
            if (function instanceof DeferringLoadBalancerExchangeFilterFunction) {
                loadBalancerFunction = function;
                continue;
            }
            if (function instanceof Ordered) {
                resultList.add(function);
                continue;
            }
            resultList.add(new OrderedExchangeFilterFunction(function));
        }
        if (loadBalancerFunction != null) {
            resultList.add(new OrderedExchangeFilterFunction(loadBalancerFunction));
        }
        resultList.sort(Comparator.comparingInt(a -> ((Ordered)a).getOrder()));
        return WebClient.builder().filters(allFilters -> allFilters.addAll(resultList));
    }

    @Bean
    public ExchangeFilterFunction webClientMetricsExchangeFilterFunction() {
        return new WebClientMetricsExchangeFilterFunction();
    }

    @Bean
    public ExchangeFilterFunction serializeContextExchangeFilterFunction() {
        return new SerializeContextExchangeFilterFunction();
    }
}

