/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.web;

import com.huaweicloud.common.adapters.web.PostClientHttpRequestInterceptor;
import com.huaweicloud.common.adapters.web.PreClientHttpRequestInterceptor;
import java.io.IOException;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class DecorateClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor,
Ordered {
    private static final int ORDER = 10000;
    private final List<PreClientHttpRequestInterceptor> preClientHttpRequestInterceptors;
    private final List<PostClientHttpRequestInterceptor> postClientHttpRequestInterceptors;

    public DecorateClientHttpRequestInterceptor(List<PreClientHttpRequestInterceptor> preClientHttpRequestInterceptors, List<PostClientHttpRequestInterceptor> postClientHttpRequestInterceptors) {
        this.preClientHttpRequestInterceptors = preClientHttpRequestInterceptors;
        this.postClientHttpRequestInterceptors = postClientHttpRequestInterceptors;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (this.preClientHttpRequestInterceptors != null) {
            this.preClientHttpRequestInterceptors.forEach(interceptor -> interceptor.process(request, body));
        }
        ClientHttpResponse clientHttpResponse = execution.execute(request, body);
        if (this.postClientHttpRequestInterceptors != null) {
            this.postClientHttpRequestInterceptors.forEach(interceptor -> interceptor.process(clientHttpResponse));
        }
        return clientHttpResponse;
    }

    public int getOrder() {
        return 10000;
    }
}

