/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.feign;

import com.huaweicloud.common.adapters.feign.DecorateRequestInterceptor;
import com.huaweicloud.common.adapters.feign.InvocationContextRequestInterceptor;
import com.huaweicloud.common.adapters.feign.OrderedRequestInterceptor;
import com.huaweicloud.common.adapters.feign.SerializeContextOrderedRequestInterceptor;
import feign.RequestInterceptor;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"feign.RequestInterceptor"})
@ConditionalOnProperty(value={"spring.cloud.servicecomb.feign.context.enabled"}, havingValue="true", matchIfMissing=true)
public class FeignConfiguration {
    @Bean
    public RequestInterceptor decorateRequestInterceptor(List<OrderedRequestInterceptor> orderedRequestInterceptors) {
        return new DecorateRequestInterceptor(orderedRequestInterceptors);
    }

    @Bean
    public RequestInterceptor invocationContextRequestInterceptor() {
        return new InvocationContextRequestInterceptor();
    }

    @Bean
    public RequestInterceptor serializeContextOrderedRequestInterceptor() {
        return new SerializeContextOrderedRequestInterceptor();
    }
}

