/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.access;

import com.google.common.eventbus.Subscribe;
import com.huaweicloud.common.access.AccessLogLogger;
import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.context.InvocationFinishEvent;
import com.huaweicloud.common.event.EventManager;
import java.util.concurrent.TimeUnit;

public class AccessLogSubscriber {
    private final ContextProperties contextProperties;
    private final AccessLogLogger accessLogLogger;

    public AccessLogSubscriber(ContextProperties contextProperties, AccessLogLogger accessLogLogger) {
        this.contextProperties = contextProperties;
        this.accessLogLogger = accessLogLogger;
        EventManager.getEventBoundedAsyncEventBus().register((Object)this);
    }

    @Subscribe
    public void onInvocationFinishEvent(InvocationFinishEvent event) {
        if (!this.contextProperties.isEnableTraceInfo()) {
            return;
        }
        this.accessLogLogger.log(event.getInvocationStage().getInvocationContext(), event.getInvocationStage().getId(), event.getInvocationStage().getStatusCode(), TimeUnit.NANOSECONDS.toMillis(event.getInvocationStage().getEndTime() - event.getInvocationStage().getBeginTime()));
    }
}

