/*
 * Decompiled with CFR 0.152.
 */
package com.gshx.zf.dzmp.util.led;

import com.gshx.zf.dzmp.util.ByteUtils;
import com.gshx.zf.dzmp.util.led.LedCmdUtil;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxUdpClient {
    private static final Logger log = LoggerFactory.getLogger(VertxUdpClient.class);
    private String ip;
    private int port;

    public VertxUdpClient(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public void sendMsg(String address, String msg, byte playMode, byte playSpeed, byte colour) {
        String cmd = LedCmdUtil.getCMD(address, msg, playMode, playSpeed, colour);
        DatagramSocket socket = Vertx.vertx().createDatagramSocket(new DatagramSocketOptions());
        Buffer buffer = Buffer.buffer((byte[])ByteUtils.hexStr2Bytes(cmd));
        socket.send(buffer, this.port, this.ip, asyncResult -> socket.close());
    }
}

