/*
 * Decompiled with CFR 0.152.
 */
package com.gshx.zf.dzmp.util.led;

import com.gshx.zf.dzmp.enums.led.LedColourEnum;
import com.gshx.zf.dzmp.enums.led.LedPlayModeEnum;
import com.gshx.zf.dzmp.enums.led.LedPlaySpeedEnum;
import com.gshx.zf.dzmp.util.ByteUtils;
import com.gshx.zf.dzmp.util.led.LedCmdUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class TcpClient {
    private Socket client;
    private String ip;
    private int port;

    public TcpClient(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsg(String address, String msg, byte playMode, byte playSpeed, byte colour) {
        try {
            this.client = new Socket(this.ip, this.port);
            OutputStream pt = this.client.getOutputStream();
            String cmd = LedCmdUtil.getCMD(address, msg, playMode, playSpeed, colour);
            byte[] bytes = ByteUtils.hexStr2Bytes(cmd);
            pt.write(bytes);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void main(String[] args) {
        TcpClient client1 = new TcpClient("o2z9135060.zicp.vip", 33059);
        client1.sendMsg("02", "\u4f60\u597d\n\u6211\u6709\u4e00\u4e2a\u5e3d\u886b", LedPlayModeEnum.COVER_UP.getValue(), LedPlaySpeedEnum.SEVEN.getValue(), LedColourEnum.RED.getValue());
    }
}

