/*
 * Decompiled with CFR 0.152.
 */
package com.gshx.zf.dzmp.util.led;

import com.gshx.zf.dzmp.util.ByteUtils;
import java.io.UnsupportedEncodingException;

public class LedCmdUtil {
    private static final String HEAD = "AA";
    private static final String GUIDE = "BB";
    private static final String COMMAND_FIRST = "51";
    private static final String COMMAND_SECOND = "54";
    private static final String TAIL = "FF";

    private static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }

    public static String getCMD(String address, String content, byte playMode, byte playSpeed, byte colour) {
        byte[] contentArray = LedCmdUtil.getGBKArray(content);
        byte[] temp = new byte[]{playMode, playSpeed, 0, colour, 99};
        byte[] allByte = LedCmdUtil.addBytes(temp, contentArray);
        String cmd = ByteUtils.bytes2HexStr(allByte, allByte.length);
        String check = ByteUtils.bytes2HexStr(LedCmdUtil.check(allByte));
        return HEAD + address + GUIDE + COMMAND_FIRST + COMMAND_SECOND + cmd + check + TAIL;
    }

    private static byte[] getGBKArray(String content) {
        byte[] carNoByteArray = null;
        try {
            carNoByteArray = content.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return carNoByteArray;
    }

    private static byte check(byte[] data) {
        byte result = data[0];
        for (int i = 1; i < data.length; ++i) {
            result = (byte)(result ^ data[i]);
        }
        return result;
    }
}

