/*
 * Decompiled with CFR 0.152.
 */
package com.gshx.zf.dzbl.util;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gshx.zf.dzbl.entity.FileInfo;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class OnlyOfficeUtil {
    @Resource
    private RestTemplate restTemplate;
    @Value(value="${thirdApis.onlyoffice.host}")
    private String onlyofficeHost;

    private String buildExampleUrl(String path, String fileId) {
        return StrUtil.replace((CharSequence)(this.onlyofficeHost + "/example" + path), (CharSequence)"{file_id}", (CharSequence)fileId);
    }

    public FileInfo getFileInfo(String fileId) {
        return (FileInfo)this.restTemplate.getForObject(this.buildExampleUrl("/wopi/files/{file_id}/contents", fileId), FileInfo.class, new Object[0]);
    }

    public byte[] getFile(String fileId) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.ALL));
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.buildExampleUrl("/wopi/files/{file_id}/contents", fileId), HttpMethod.GET, httpEntity, byte[].class, new Object[0]);
        if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
            return (byte[])response.getBody();
        }
        throw new IOException("Failed to download file");
    }

    public String lock(String fileId) {
        String lock = IdWorker.get32UUID();
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"X-WOPI-Override", (Object)"LOCK");
        headers.add((Object)"X-WOPI-Lock", (Object)lock);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        this.restTemplate.exchange(this.buildExampleUrl("/wopi/files/{file_id}", fileId), HttpMethod.POST, httpEntity, String.class, new Object[0]);
        return lock;
    }

    public void unlock(String fileId, String lock) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"X-WOPI-Override", (Object)"UNLOCK");
        headers.add((Object)"X-WOPI-Lock", (Object)lock);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        this.restTemplate.exchange(this.buildExampleUrl("/wopi/files/{file_id}", fileId), HttpMethod.POST, httpEntity, String.class, new Object[0]);
    }

    public void putFile(String fileId, String lock, byte[] fileContent) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"X-WOPI-Override", (Object)"PUT");
        headers.add((Object)"X-WOPI-Lock", (Object)lock);
        HttpEntity httpEntity = new HttpEntity((Object)fileContent, (MultiValueMap)headers);
        this.restTemplate.exchange(this.buildExampleUrl("/wopi/files/{file_id}/contents", fileId), HttpMethod.POST, httpEntity, String.class, new Object[0]);
    }
}

