/*
 * Decompiled with CFR 0.152.
 */
package com.gshx.zf.dzbl.service.impl;

import com.gshx.zf.dzbl.modifier.ModifierFactory;
import com.gshx.zf.dzbl.service.OfficeService;
import com.gshx.zf.dzbl.util.OnlyOfficeUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OfficeServiceImpl
implements OfficeService {
    private static final Logger log = LoggerFactory.getLogger(OfficeServiceImpl.class);
    @Resource
    private OnlyOfficeUtil onlyOfficeUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyDocx(String fileId, Map<String, String> replacements) {
        String lock = this.onlyOfficeUtil.lock(fileId);
        try {
            byte[] file = this.onlyOfficeUtil.getFile(fileId);
            byte[] bytes = ModifierFactory.createModifier(fileId).modify(file, replacements);
            this.onlyOfficeUtil.putFile(fileId, lock, bytes);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.onlyOfficeUtil.unlock(fileId, lock);
        }
    }
}

