/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.internal;

import com.gs.collections.api.bag.sorted.SortedBag;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SortedBagIterables {
    private SortedBagIterables() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> int compare(SortedBag<T> bagA, SortedBag<T> bagB) {
        Iterator itrA = bagA.iterator();
        Iterator itrB = bagB.iterator();
        if (bagA.comparator() != null) {
            Comparator comparator = bagA.comparator();
            while (itrA.hasNext()) {
                if (itrB.hasNext()) {
                    int val = comparator.compare(itrA.next(), itrB.next());
                    if (val == 0) continue;
                    return val;
                }
                return 1;
            }
            return itrB.hasNext() ? -1 : 0;
        }
        while (itrA.hasNext()) {
            if (itrB.hasNext()) {
                int val = ((Comparable)itrA.next()).compareTo(itrB.next());
                if (val == 0) continue;
                return val;
            }
            return 1;
        }
        return itrB.hasNext() ? -1 : 0;
    }
}

