/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.stack.primitive.MutableLongStackFactory;
import com.gs.collections.api.stack.primitive.MutableLongStack;
import com.gs.collections.impl.stack.mutable.primitive.LongArrayStack;

public class MutableLongStackFactoryImpl
implements MutableLongStackFactory {
    public MutableLongStack empty() {
        return new LongArrayStack();
    }

    public MutableLongStack of() {
        return this.empty();
    }

    public MutableLongStack with() {
        return this.empty();
    }

    public MutableLongStack of(long ... items) {
        return this.with(items);
    }

    public MutableLongStack with(long ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return LongArrayStack.newStackWith(items);
    }

    public MutableLongStack ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public MutableLongStack withAll(LongIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return LongArrayStack.newStack(items);
    }

    public MutableLongStack ofAllReversed(LongIterable items) {
        return this.withAllReversed(items);
    }

    public MutableLongStack withAllReversed(LongIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return LongArrayStack.newStackFromTopToBottom(items);
    }
}

