/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableIntStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableIntStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableIntArrayStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableIntEmptyStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableIntSingletonStack;

public class ImmutableIntStackFactoryImpl
implements ImmutableIntStackFactory {
    public ImmutableIntStack empty() {
        return ImmutableIntEmptyStack.INSTANCE;
    }

    public ImmutableIntStack of() {
        return this.empty();
    }

    public ImmutableIntStack with() {
        return this.empty();
    }

    public ImmutableIntStack of(int one) {
        return this.with(one);
    }

    public ImmutableIntStack with(int one) {
        return new ImmutableIntSingletonStack(one);
    }

    public ImmutableIntStack of(int ... items) {
        return this.with(items);
    }

    public ImmutableIntStack with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntArrayStack.newStackWith(items);
    }

    public ImmutableIntStack ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public ImmutableIntStack withAll(IntIterable items) {
        if (items instanceof ImmutableIntStack) {
            return (ImmutableIntStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableIntStack ofAllReversed(IntIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableIntStack withAllReversed(IntIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableIntArrayStack.newStackFromTopToBottom(items);
    }
}

