/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.ParallelListIterable;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.list.MutableListMultimap;
import com.gs.collections.api.ordered.OrderedIterable;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.collection.mutable.AbstractMultiReaderMutableCollection;
import com.gs.collections.impl.factory.Iterables;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.lazy.ReverseIterable;
import com.gs.collections.impl.lazy.parallel.list.ListIterableParallelIterable;
import com.gs.collections.impl.lazy.parallel.list.MultiReaderParallelListIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.SynchronizedMutableList;
import com.gs.collections.impl.list.mutable.UnmodifiableMutableList;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import com.gs.collections.impl.utility.LazyIterate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Random;
import java.util.RandomAccess;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiReaderFastList<T>
extends AbstractMultiReaderMutableCollection<T>
implements RandomAccess,
Externalizable,
MutableList<T> {
    private static final long serialVersionUID = 1L;
    private transient ReadWriteLock lock;
    private MutableList<T> delegate;

    @Deprecated
    public MultiReaderFastList() {
    }

    private MultiReaderFastList(MutableList<T> newDelegate) {
        this(newDelegate, new ReentrantReadWriteLock());
    }

    private MultiReaderFastList(MutableList<T> newDelegate, ReadWriteLock newLock) {
        this.lock = newLock;
        this.delegate = newDelegate;
    }

    public static <T> MultiReaderFastList<T> newList() {
        return new MultiReaderFastList(FastList.newList());
    }

    public static <T> MultiReaderFastList<T> newList(int capacity) {
        return new MultiReaderFastList(FastList.newList(capacity));
    }

    public static <T> MultiReaderFastList<T> newList(Iterable<T> iterable) {
        return new MultiReaderFastList<T>(FastList.newList(iterable));
    }

    public static <T> MultiReaderFastList<T> newListWith(T ... elements) {
        return new MultiReaderFastList<T>(FastList.newListWith(elements));
    }

    @Override
    protected MutableList<T> getDelegate() {
        return this.delegate;
    }

    @Override
    protected ReadWriteLock getLock() {
        return this.lock;
    }

    UntouchableMutableList<T> asReadUntouchable() {
        return new UntouchableMutableList(this.delegate.asUnmodifiable());
    }

    UntouchableMutableList<T> asWriteUntouchable() {
        return new UntouchableMutableList(this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withReadLockAndDelegate(Procedure<MutableList<T>> procedure) {
        this.acquireReadLock();
        try {
            UntouchableMutableList<T> list = this.asReadUntouchable();
            procedure.value(list);
            list.becomeUseless();
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withWriteLockAndDelegate(Procedure<MutableList<T>> procedure) {
        this.acquireWriteLock();
        try {
            UntouchableMutableList<T> list = this.asWriteUntouchable();
            procedure.value(list);
            list.becomeUseless();
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> asSynchronized() {
        this.acquireReadLock();
        try {
            SynchronizedMutableList synchronizedMutableList = SynchronizedMutableList.of(this);
            return synchronizedMutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> asUnmodifiable() {
        this.acquireReadLock();
        try {
            UnmodifiableMutableList unmodifiableMutableList = UnmodifiableMutableList.of(this);
            return unmodifiableMutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<T> toImmutable() {
        this.acquireReadLock();
        try {
            ImmutableList immutableList = Lists.immutable.withAll(this.delegate);
            return immutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> clone() {
        this.acquireReadLock();
        try {
            MultiReaderFastList<T> multiReaderFastList = new MultiReaderFastList<T>(this.delegate.clone());
            return multiReaderFastList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.collect(function);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        this.acquireReadLock();
        try {
            MutableBooleanList mutableBooleanList = this.delegate.collectBoolean(booleanFunction);
            return mutableBooleanList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        this.acquireReadLock();
        try {
            MutableByteList mutableByteList = this.delegate.collectByte(byteFunction);
            return mutableByteList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        this.acquireReadLock();
        try {
            MutableCharList mutableCharList = this.delegate.collectChar(charFunction);
            return mutableCharList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        this.acquireReadLock();
        try {
            MutableDoubleList mutableDoubleList = this.delegate.collectDouble(doubleFunction);
            return mutableDoubleList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        this.acquireReadLock();
        try {
            MutableFloatList mutableFloatList = this.delegate.collectFloat(floatFunction);
            return mutableFloatList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        this.acquireReadLock();
        try {
            MutableIntList mutableIntList = this.delegate.collectInt(intFunction);
            return mutableIntList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        this.acquireReadLock();
        try {
            MutableLongList mutableLongList = this.delegate.collectLong(longFunction);
            return mutableLongList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        this.acquireReadLock();
        try {
            MutableShortList mutableShortList = this.delegate.collectShort(shortFunction);
            return mutableShortList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.flatCollect(function);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.collectIf(predicate, function);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.collectWith(function, parameter);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableList<T> newEmpty() {
        return MultiReaderFastList.newList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> reject(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.reject(predicate);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.rejectWith(predicate, parameter);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> tap(Procedure<? super T> procedure) {
        this.acquireReadLock();
        try {
            this.forEach(procedure);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> select(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.select(predicate);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.selectWith(predicate, parameter);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            PartitionMutableList partitionMutableList = this.delegate.partition(predicate);
            return partitionMutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            PartitionMutableList partitionMutableList = this.delegate.partitionWith(predicate, parameter);
            return partitionMutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.selectInstancesOf(clazz);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> distinct() {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.distinct();
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> distinct(HashingStrategy<? super T> hashingStrategy) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.distinct(hashingStrategy);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThis() {
        this.acquireWriteLock();
        try {
            this.delegate.sortThis();
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThis(Comparator<? super T> comparator) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThis(comparator);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> MutableList<T> sortThisBy(Function<? super T, ? extends V> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisBy(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByInt(IntFunction<? super T> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisByInt(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByBoolean(BooleanFunction<? super T> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisByBoolean(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByChar(CharFunction<? super T> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisByChar(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByByte(ByteFunction<? super T> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisByByte(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByShort(ShortFunction<? super T> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisByShort(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByFloat(FloatFunction<? super T> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisByFloat(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByLong(LongFunction<? super T> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisByLong(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByDouble(DoubleFunction<? super T> function) {
        this.acquireWriteLock();
        try {
            this.delegate.sortThisByDouble(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> subList(int fromIndex, int toIndex) {
        this.acquireReadLock();
        try {
            MultiReaderFastList<T> multiReaderFastList = new MultiReaderFastList<T>(this.delegate.subList(fromIndex, toIndex), this.lock);
            return multiReaderFastList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        this.acquireReadLock();
        try {
            boolean bl = this.delegate.equals(o);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.acquireReadLock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index) {
        this.acquireReadLock();
        try {
            Object object = this.delegate.get(index);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        this.acquireReadLock();
        try {
            int n = this.delegate.indexOf(o);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        this.acquireReadLock();
        try {
            int n = this.delegate.lastIndexOf(o);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableList<T> with(T element) {
        this.add(element);
        return this;
    }

    public MutableList<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableList<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public MutableList<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("ListIterator is not supported for MultiReaderFastList.  If you would like to use a ListIterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("ListIterator is not supported for MultiReaderFastList.  If you would like to use a ListIterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int index) {
        this.acquireWriteLock();
        try {
            Object object = this.delegate.remove(index);
            return (T)object;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(int index, T element) {
        this.acquireWriteLock();
        try {
            Object object = this.delegate.set(index, element);
            return (T)object;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection<? extends T> collection) {
        this.acquireWriteLock();
        try {
            boolean bl = this.delegate.addAll(index, collection);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, T element) {
        this.acquireWriteLock();
        try {
            this.delegate.add(index, element);
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        this.acquireReadLock();
        try {
            boolean bl = this.delegate.corresponds(other, predicate);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(int startIndex, int endIndex, Procedure<? super T> procedure) {
        this.acquireReadLock();
        try {
            this.delegate.forEach(startIndex, endIndex, procedure);
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int binarySearch(T key, Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            int n = Collections.binarySearch(this, key, comparator);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int binarySearch(T key) {
        this.acquireReadLock();
        try {
            int n = Collections.binarySearch(this, key);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public void reverseForEach(final Procedure<? super T> procedure) {
        this.withReadLockRun(new Runnable(){

            public void run() {
                MultiReaderFastList.this.getDelegate().reverseForEach(procedure);
            }
        });
    }

    public void forEachWithIndex(final int fromIndex, final int toIndex, final ObjectIntProcedure<? super T> objectIntProcedure) {
        this.withReadLockRun(new Runnable(){

            public void run() {
                MultiReaderFastList.this.getDelegate().forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
            }
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MutableList)in.readObject();
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectIndex(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().detectIndex(predicate);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectLastIndex(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().detectLastIndex(predicate);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableListMultimap mutableListMultimap = this.delegate.groupBy(function);
            return mutableListMultimap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        this.acquireReadLock();
        try {
            MutableListMultimap mutableListMultimap = this.delegate.groupByEach(function);
            return mutableListMultimap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableMap mutableMap = this.delegate.groupByUniqueKey(function);
            return mutableMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.zip(that);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<Pair<T, Integer>> zipWithIndex() {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.zipWithIndex();
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> toReversed() {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.toReversed();
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> reverseThis() {
        this.acquireWriteLock();
        try {
            this.delegate.reverseThis();
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> shuffleThis() {
        this.acquireWriteLock();
        try {
            this.delegate.shuffleThis();
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> shuffleThis(Random rnd) {
        this.acquireWriteLock();
        try {
            this.delegate.shuffleThis(rnd);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> toStack() {
        this.acquireReadLock();
        try {
            MutableStack mutableStack = this.delegate.toStack();
            return mutableStack;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<RichIterable<T>> chunk(int size) {
        this.acquireReadLock();
        try {
            RichIterable richIterable = this.delegate.chunk(size);
            return richIterable;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> take(int count) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.take(count);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> takeWhile(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.takeWhile(predicate);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> drop(int count) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.drop(count);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> dropWhile(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.dropWhile(predicate);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableList<T> partitionWhile(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            PartitionMutableList partitionMutableList = this.delegate.partitionWhile(predicate);
            return partitionMutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyIterable<T> asReversed() {
        this.acquireReadLock();
        try {
            ReverseIterable reverseIterable = ReverseIterable.adapt(this);
            return reverseIterable;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public ParallelListIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new MultiReaderParallelListIterable(this.delegate.asParallel(executorService, batchSize), this.lock);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UntouchableListIterator<T>
    implements ListIterator<T> {
        private Iterator<T> delegate;

        private UntouchableListIterator(Iterator<T> newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        public void add(T o) {
            ((ListIterator)this.delegate).add(o);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return ((ListIterator)this.delegate).hasPrevious();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public int nextIndex() {
            return ((ListIterator)this.delegate).nextIndex();
        }

        @Override
        public T previous() {
            return (T)((ListIterator)this.delegate).previous();
        }

        @Override
        public int previousIndex() {
            return ((ListIterator)this.delegate).previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void set(T o) {
            ((ListIterator)this.delegate).set(o);
        }

        public void becomeUseless() {
            this.delegate = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UntouchableMutableList<T>
    extends AbstractMultiReaderMutableCollection.UntouchableMutableCollection<T>
    implements MutableList<T> {
        private final MutableList<UntouchableListIterator<T>> requestedIterators = Iterables.mList();
        private final MutableList<UntouchableMutableList<T>> requestedSubLists = Iterables.mList();

        private UntouchableMutableList(MutableList<T> delegate) {
            this.delegate = delegate;
        }

        public MutableList<T> with(T element) {
            this.add(element);
            return this;
        }

        public MutableList<T> without(T element) {
            this.remove(element);
            return this;
        }

        public MutableList<T> withAll(Iterable<? extends T> elements) {
            this.addAllIterable(elements);
            return this;
        }

        public MutableList<T> withoutAll(Iterable<? extends T> elements) {
            this.removeAllIterable(elements);
            return this;
        }

        public MutableList<T> asSynchronized() {
            throw new UnsupportedOperationException("Cannot call asSynchronized() on " + this.getClass().getSimpleName());
        }

        public MutableList<T> asUnmodifiable() {
            throw new UnsupportedOperationException("Cannot call asUnmodifiable() on " + this.getClass().getSimpleName());
        }

        public LazyIterable<T> asLazy() {
            return LazyIterate.adapt(this);
        }

        public ImmutableList<T> toImmutable() {
            return this.getDelegate().toImmutable();
        }

        public MutableList<T> clone() {
            return this.getDelegate().clone();
        }

        public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
            return this.getDelegate().collect(function);
        }

        public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }

        public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
            return (R)this.getDelegate().collectBoolean(booleanFunction, target);
        }

        public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
            return this.getDelegate().collectByte(byteFunction);
        }

        public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
            return (R)this.getDelegate().collectByte(byteFunction, target);
        }

        public MutableCharList collectChar(CharFunction<? super T> charFunction) {
            return this.getDelegate().collectChar(charFunction);
        }

        public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
            return (R)this.getDelegate().collectChar(charFunction, target);
        }

        public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
            return this.getDelegate().collectDouble(doubleFunction);
        }

        public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
            return (R)this.getDelegate().collectDouble(doubleFunction, target);
        }

        public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
            return this.getDelegate().collectFloat(floatFunction);
        }

        public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
            return (R)this.getDelegate().collectFloat(floatFunction, target);
        }

        public MutableIntList collectInt(IntFunction<? super T> intFunction) {
            return this.getDelegate().collectInt(intFunction);
        }

        public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
            return (R)this.getDelegate().collectInt(intFunction, target);
        }

        public MutableLongList collectLong(LongFunction<? super T> longFunction) {
            return this.getDelegate().collectLong(longFunction);
        }

        public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
            return (R)this.getDelegate().collectLong(longFunction, target);
        }

        public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
            return this.getDelegate().collectShort(shortFunction);
        }

        public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
            return (R)this.getDelegate().collectShort(shortFunction, target);
        }

        public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().flatCollect(function);
        }

        public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
            return this.getDelegate().collectIf(predicate, function);
        }

        public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
            return this.getDelegate().collectWith(function, parameter);
        }

        public int detectIndex(Predicate<? super T> predicate) {
            return this.getDelegate().detectIndex(predicate);
        }

        public int detectLastIndex(Predicate<? super T> predicate) {
            return this.getDelegate().detectLastIndex(predicate);
        }

        public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupBy(function);
        }

        public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().groupByEach(function);
        }

        public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupByUniqueKey(function);
        }

        public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
            return this.getDelegate().corresponds(other, predicate);
        }

        public void forEach(int fromIndex, int toIndex, Procedure<? super T> procedure) {
            this.getDelegate().forEach(fromIndex, toIndex, procedure);
        }

        public void reverseForEach(Procedure<? super T> procedure) {
            this.getDelegate().reverseForEach(procedure);
        }

        public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
            this.getDelegate().forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        }

        public MutableList<T> newEmpty() {
            return this.getDelegate().newEmpty();
        }

        public MutableList<T> reject(Predicate<? super T> predicate) {
            return this.getDelegate().reject(predicate);
        }

        public MutableList<T> distinct() {
            return this.getDelegate().distinct();
        }

        public MutableList<T> distinct(HashingStrategy<? super T> hashingStrategy) {
            return this.getDelegate().distinct(hashingStrategy);
        }

        public <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }

        public MutableList<T> tap(Procedure<? super T> procedure) {
            this.forEach(procedure);
            return this;
        }

        public MutableList<T> select(Predicate<? super T> predicate) {
            return this.getDelegate().select(predicate);
        }

        public <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().selectWith(predicate, parameter);
        }

        public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
            return this.getDelegate().partition(predicate);
        }

        public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }

        public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
            return this.getDelegate().selectInstancesOf(clazz);
        }

        public MutableList<T> sortThis() {
            this.getDelegate().sortThis();
            return this;
        }

        public MutableList<T> sortThis(Comparator<? super T> comparator) {
            this.getDelegate().sortThis(comparator);
            return this;
        }

        public MutableList<T> toReversed() {
            return this.getDelegate().toReversed();
        }

        public MutableList<T> reverseThis() {
            this.getDelegate().reverseThis();
            return this;
        }

        public MutableList<T> shuffleThis() {
            this.getDelegate().shuffleThis();
            return this;
        }

        public MutableList<T> shuffleThis(Random rnd) {
            this.getDelegate().shuffleThis(rnd);
            return this;
        }

        public MutableStack<T> toStack() {
            return ArrayStack.newStack(this.delegate);
        }

        public <V extends Comparable<? super V>> MutableList<T> sortThisBy(Function<? super T, ? extends V> function) {
            this.getDelegate().sortThisBy(function);
            return this;
        }

        public MutableList<T> sortThisByInt(IntFunction<? super T> function) {
            this.getDelegate().sortThisByInt(function);
            return this;
        }

        public MutableList<T> sortThisByBoolean(BooleanFunction<? super T> function) {
            this.getDelegate().sortThisByBoolean(function);
            return this;
        }

        public MutableList<T> sortThisByChar(CharFunction<? super T> function) {
            this.getDelegate().sortThisByChar(function);
            return this;
        }

        public MutableList<T> sortThisByByte(ByteFunction<? super T> function) {
            this.getDelegate().sortThisByByte(function);
            return this;
        }

        public MutableList<T> sortThisByShort(ShortFunction<? super T> function) {
            this.getDelegate().sortThisByShort(function);
            return this;
        }

        public MutableList<T> sortThisByFloat(FloatFunction<? super T> function) {
            this.getDelegate().sortThisByFloat(function);
            return this;
        }

        public MutableList<T> sortThisByLong(LongFunction<? super T> function) {
            this.getDelegate().sortThisByLong(function);
            return this;
        }

        public MutableList<T> sortThisByDouble(DoubleFunction<? super T> function) {
            this.getDelegate().sortThisByDouble(function);
            return this;
        }

        public MutableList<T> take(int count) {
            return this.getDelegate().take(count);
        }

        public MutableList<T> takeWhile(Predicate<? super T> predicate) {
            return this.getDelegate().takeWhile(predicate);
        }

        public MutableList<T> drop(int count) {
            return this.getDelegate().drop(count);
        }

        public MutableList<T> dropWhile(Predicate<? super T> predicate) {
            return this.getDelegate().dropWhile(predicate);
        }

        public PartitionMutableList<T> partitionWhile(Predicate<? super T> predicate) {
            return this.getDelegate().partitionWhile(predicate);
        }

        public MutableList<T> subList(int fromIndex, int toIndex) {
            UntouchableMutableList<T> subList = new UntouchableMutableList<T>(this.getDelegate().subList(fromIndex, toIndex));
            this.requestedSubLists.add(subList);
            return subList;
        }

        public Iterator<T> iterator() {
            UntouchableListIterator iterator = new UntouchableListIterator(this.delegate.iterator());
            this.requestedIterators.add(iterator);
            return iterator;
        }

        public void add(int index, T element) {
            this.getDelegate().add(index, element);
        }

        public boolean addAll(int index, Collection<? extends T> collection) {
            return this.getDelegate().addAll(index, collection);
        }

        public T get(int index) {
            return (T)this.getDelegate().get(index);
        }

        public int indexOf(Object o) {
            return this.getDelegate().indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.getDelegate().lastIndexOf(o);
        }

        public ListIterator<T> listIterator() {
            UntouchableListIterator iterator = new UntouchableListIterator(this.getDelegate().listIterator());
            this.requestedIterators.add(iterator);
            return iterator;
        }

        public ListIterator<T> listIterator(int index) {
            UntouchableListIterator iterator = new UntouchableListIterator(this.getDelegate().listIterator(index));
            this.requestedIterators.add(iterator);
            return iterator;
        }

        public T remove(int index) {
            return (T)this.getDelegate().remove(index);
        }

        public T set(int index, T element) {
            return (T)this.getDelegate().set(index, element);
        }

        public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
            return this.getDelegate().zip(that);
        }

        public MutableList<Pair<T, Integer>> zipWithIndex() {
            return this.getDelegate().zipWithIndex();
        }

        public LazyIterable<T> asReversed() {
            return ReverseIterable.adapt(this);
        }

        public ParallelListIterable<T> asParallel(ExecutorService executorService, int batchSize) {
            return new ListIterableParallelIterable(this, executorService, batchSize);
        }

        public int binarySearch(T key, Comparator<? super T> comparator) {
            return Collections.binarySearch(this, key, comparator);
        }

        public int binarySearch(T key) {
            return Collections.binarySearch(this, key);
        }

        public void becomeUseless() {
            this.delegate = null;
            this.requestedSubLists.forEach(new Procedure<UntouchableMutableList<T>>(){

                public void value(UntouchableMutableList<T> each) {
                    each.becomeUseless();
                }
            });
            this.requestedIterators.forEach(new Procedure<UntouchableListIterator<T>>(){

                public void value(UntouchableListIterator<T> each) {
                    each.becomeUseless();
                }
            });
        }

        private MutableList<T> getDelegate() {
            return (MutableList)this.delegate;
        }
    }
}

