/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.stack.primitive.MutableLongStackFactory;
import com.gs.collections.api.stack.primitive.MutableLongStack;

/**
 * MutableLongStackFactoryImpl is a factory implementation which creates instances of type {@link MutableLongStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableLongStackFactoryImpl implements MutableLongStackFactory
{
    public MutableLongStack empty()
    {
        return new LongArrayStack();
    }

    public MutableLongStack of()
    {
        return this.empty();
    }

    public MutableLongStack with()
    {
        return this.empty();
    }

    public MutableLongStack of(long... items)
    {
        return this.with(items);
    }

    public MutableLongStack with(long... items)
    {
        if (items.length == 0)
        {
            return this.empty();
        }
        return LongArrayStack.newStackWith(items);
    }

    public MutableLongStack ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public MutableLongStack withAll(LongIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return LongArrayStack.newStack(items);
    }

    public MutableLongStack ofAllReversed(LongIterable items)
    {
        return this.withAllReversed(items);
    }

    public MutableLongStack withAllReversed(LongIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return LongArrayStack.newStackFromTopToBottom(items);
    }
}
