/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.stack.primitive.MutableFloatStackFactory;
import com.gs.collections.api.stack.primitive.MutableFloatStack;

/**
 * MutableFloatStackFactoryImpl is a factory implementation which creates instances of type {@link MutableFloatStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableFloatStackFactoryImpl implements MutableFloatStackFactory
{
    public MutableFloatStack empty()
    {
        return new FloatArrayStack();
    }

    public MutableFloatStack of()
    {
        return this.empty();
    }

    public MutableFloatStack with()
    {
        return this.empty();
    }

    public MutableFloatStack of(float... items)
    {
        return this.with(items);
    }

    public MutableFloatStack with(float... items)
    {
        if (items.length == 0)
        {
            return this.empty();
        }
        return FloatArrayStack.newStackWith(items);
    }

    public MutableFloatStack ofAll(FloatIterable items)
    {
        return this.withAll(items);
    }

    public MutableFloatStack withAll(FloatIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return FloatArrayStack.newStack(items);
    }

    public MutableFloatStack ofAllReversed(FloatIterable items)
    {
        return this.withAllReversed(items);
    }

    public MutableFloatStack withAllReversed(FloatIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return FloatArrayStack.newStackFromTopToBottom(items);
    }
}
