/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableIntStack;
import com.gs.collections.api.stack.primitive.IntStack;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.IntStacks;
import com.gs.collections.impl.iterator.ImmutableEmptyIntIterator;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableIntEmptyStack is an optimization for {@link ImmutableIntStack} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyStack.stg.
 */
@Immutable
final class ImmutableIntEmptyStack implements ImmutableIntStack, Serializable
{
    static final ImmutableIntStack INSTANCE = new ImmutableIntEmptyStack();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public IntIterator intIterator()
    {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    public void forEach(IntProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(IntProcedure procedure)
    {
    }

    public int count(IntPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public int peek()
    {
        throw new EmptyStackException();
    }

    public IntList peek(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return new IntArrayList(0);
        }
        throw new EmptyStackException();
    }

    public int peekAt(int index)
    {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableIntStack select(IntPredicate predicate)
    {
        return this;
    }

    public ImmutableIntStack reject(IntPredicate predicate)
    {
        return this;
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(IntToObjectFunction<? extends V> function)
    {
        return Stacks.immutable.of();
    }

    public long sum()
    {
        return 0;
    }

    public int max()
    {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public int min()
    {
        throw new NoSuchElementException();
    }

    public int minIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public int[] toSortedArray()
    {
        return new int[0];
    }

    public MutableIntList toSortedList()
    {
        return new IntArrayList();
    }

    public int[] toArray()
    {
        return new int[0];
    }

    public boolean contains(int value)
    {
        return false;
    }

    public boolean containsAll(int... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source)
    {
        return source.isEmpty();
    }

    public MutableIntList toList()
    {
        return new IntArrayList();
    }

    public MutableIntSet toSet()
    {
        return new IntHashSet();
    }

    public MutableIntBag toBag()
    {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public ImmutableIntStack toImmutable()
    {
        return this;
    }

    public ImmutableIntStack push(int element)
    {
        return IntStacks.immutable.with(element);
    }

    public ImmutableIntStack pop()
    {
        throw new EmptyStackException();
    }

    public ImmutableIntStack pop(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack)
    {
        if (otherStack == this)
        {
            return true;
        }
        if (!(otherStack instanceof IntStack))
        {
            return false;
        }
        IntStack stack = (IntStack) otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
