/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableBooleanSet;
import com.gs.collections.api.set.primitive.BooleanSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableBooleanCollection;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveSet.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableBooleanSet
        extends AbstractUnmodifiableBooleanCollection
        implements MutableBooleanSet
{
    private static final long serialVersionUID = 1L;

    UnmodifiableBooleanSet(MutableBooleanSet set)
    {
        super(set);
    }

    /**
     * This method will take a MutableBooleanSet and wrap it directly in a UnmodifiableBooleanSet.
     */
    public static UnmodifiableBooleanSet of(MutableBooleanSet set)
    {
        if (set == null)
        {
            throw new IllegalArgumentException("cannot create an UnmodifiableBooleanSet for null");
        }
        return new UnmodifiableBooleanSet(set);
    }

    private MutableBooleanSet getMutableBooleanSet()
    {
        return (MutableBooleanSet) this.getBooleanCollection();
    }

    @Override
    public UnmodifiableBooleanSet with(boolean element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanSet without(boolean element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanSet withAll(BooleanIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableBooleanSet withoutAll(BooleanIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableBooleanSet select(BooleanPredicate predicate)
    {
        return this.getMutableBooleanSet().select(predicate);
    }

    @Override
    public MutableBooleanSet reject(BooleanPredicate predicate)
    {
        return this.getMutableBooleanSet().reject(predicate);
    }

    @Override
    public <V> MutableSet<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.getMutableBooleanSet().collect(function);
    }

    @Override
    public boolean equals(Object otherSet)
    {
        return this.getMutableBooleanSet().equals(otherSet);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableBooleanSet().hashCode();
    }

    @Override
    public MutableBooleanSet asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableBooleanSet asSynchronized()
    {
        return new SynchronizedBooleanSet(this);
    }

    public BooleanSet freeze()
    {
        return this.getMutableBooleanSet().freeze();
    }

    @Override
    public ImmutableBooleanSet toImmutable()
    {
        return this.getMutableBooleanSet().toImmutable();
    }
}
